define(['vue', 'jquery'], function (Vue) {
    function drag(el, binding) {
        //获取元素
        var dialog = $(el);
        var title = dialog.find('.dialog_title');
        var x = 0;
        var y = 0;
        var l = 0;
        var t = 0;
        var isDown = false;
        //鼠标按下事件
        title.on('mousedown', function (e) {
            //获取x坐标和y坐标
            x = e.clientX;
            y = e.clientY;

            //获取左部和顶部的偏移量
            l = dialog.offset().left;
            t = dialog.offset().top;
            //开关打开
            isDown = true;
        })
        //鼠标移动
        window.onmousemove = function (e) {
            if (isDown == false) {
                return;
            }
            //获取x和y
            var nx = e.clientX;
            var ny = e.clientY;
            var height = dialog.outerHeight();
            var width = dialog.outerWidth();
            var clientWidth = document.documentElement.clientWidth;
            var clientHeight = document.documentElement.clientHeight;
            var limitWidth = clientWidth - width
            var limitHeight = clientHeight - height

            //计算移动后的左偏移量和顶部的偏移量
            var nl = nx - Math.abs(x - l);
            var nt = ny - Math.abs(y - t);
            nl = nl > 0 ? nl : 0
            nl = nl < limitWidth ? nl : limitWidth
            nt = nt > 0 ? nt : 0
            nt = nt < limitHeight ? nt : limitHeight


            dialog.css({left: nl, top: nt, right: 'auto', bottom: 'auto'})
        }
        //鼠标抬起事件
        title.on('mouseup', function () {
            //开关关闭
            isDown = false;
        })
    }

    Vue.directive('dialog-drag', {
        bind: function (el, binding) {
            drag(el, binding)
        }
    })
})
