//上传文件显示组件
define(['vue'], function (Vue) {
    return Vue.component('files-detail', {
        props: {
            files: {
                default: function () {
                    return [];
                }
            },
            filesId: {
                default: function () {
                    return [];
                }
            },
        },
        template: ' <div class="pointer">\
                        <a v-if="innerFiles.length!=0" v-for="(item ,index) in innerFiles" @click="downloadFile(item)" :title="item.name">{{item.name}} ({{autoUnitSize(item.size)}})<br></a>\
                    </div> ',
        data: function () {
            return {
                innerFiles: this.files,     //文件内部变量
                innerFilesId: this.filesId,     //文件内部变量
            }
        },
        created: function () {
        },
        mounted: function () {

        },
        watch: {
            files: {
                handler: function (val, oldVal) {
                    this.innerFiles = val
                }, immediate: true
            },
            filesId: {
                handler: function (val, oldVal) {
                    this.innerFilesId = val
                }, immediate: true
            },
            innerFilesId: {
                handler: function (val, oldVal) {
                    //如果指定了filesId，根据filesId获取文件
                    if (val != null && val.length > 0 && val != oldVal) {
                        this.queryFile(val);
                    }
                }, immediate: true
            }
        },

        methods: {
            //模拟表单下载文件
            downloadFile: function (item) {
                var url = getContextPath() + "/api/file/download/" + item.id;
                var fileName = item.name;
                var form = $("<form></form>").attr("action", url).attr("method", "POST");
                form.append($("<input></input>").attr("type", "hidden").attr("name", "fileName").attr("value", fileName));
                form.appendTo('body').submit().remove();
            },
            //根据文件大小自动选择单位显示
            autoUnitSize: function (size) {
                if (size < 1024)
                    return size + ' B';

                if (size >= 1024 && size < 1024 * 1024)
                    return (size / 1024).toFixed(2) + ' KB';

                if (size >= 1024 * 1024 && size < 1024 * 1024 * 1024)
                    return (size / (1024 * 1024)).toFixed(2) + ' MB';

                return (size / (1024 * 1024 * 1024)).toFixed(2) + ' GB';
                //1024 * 1024 * 1024 > int.MaxValue
            },
            queryFile: function (filesId) {
                var that = this;
                $.ajax({
                    type: 'GET',
                    url: getContextPath() + '/api/file/query-by-ids',
                    data: {ids: filesId},
                    success: function (res) {
                        if ((typeof res != 'undefined') && (null != res) && (0 !== res.length))
                            that.innerFiles = res.data;
                    }
                });
            },
        }
    });
});
