//流程引擎历史记录组件
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('process-engine-history-extend', {
        template: '<div class="block_container">\
        <div style="float: right">\
        <label><input type="checkbox" @click="showSystem = !showSystem" class="processv2-check" /> 显示系统活动</label>\
        </div>\
        <div style="color: #333333; font-weight: normal;">\
        <table class="table table_list table_striped text_center" style="text-align: center;">\
            <thead>\
                <tr>\
                    <th>序号</th>\
                    <th>流程步骤</th>\
                    <th>处理人</th>\
                    <th v-if="historiesExtend.extendEnabled">{{historiesExtend.extendName}}</th>\
                    <th>送达时间</th>\
                    <th>完成时间</th>\
                    <th>状态</th>\
                    <th>处理意见/结果</th>\
                </tr>\
            </thead>\
            <tbody>\
                <template v-for="(history, index) in filterHistories">\
                <tr v-if="history.activityType != \'SubprocessBegin\' && history.activityType != \'SubprocessEnd\'">\
                    <td>{{index + 1}}</td>\
                    <td>{{history.activityName}}</td>\
                    <td>{{history.actorName}}</td>\
                    <td style="text-align: left;" v-if="historiesExtend.extendEnabled">{{history.extendData?JSON.parse(history.extendData):\'\'}}</td>\
                    <td>{{history.beginTime}}</td>\
                    <td>{{history.finishTime}}</td>\
                    <td style="white-space: nowrap;">{{getHistoryState(history)}}</td>\
                    <td style="text-align: left;">{{history.comment}}</td>\
                </tr>\
                <tr v-if="history.activityType == \'SubprocessBegin\'" style="background-image: linear-gradient(to bottom, #DDDDDD, #FFFFFF);">\
                    <td>{{index + 1}}</td>\
                    <td colspan="6">{{history.activityName}} （{{history.finished?"已结束":"未结束"}}）</td>\
                </tr>\
                <tr v-if="history.activityType == \'SubprocessEnd\'" style="background-image: linear-gradient(to bottom, #FFFFFF, #DDDDDD);">\
                    <td colspan="7"></td>\
                    \
                </tr>\
                </template>\
            </tbody>\
        </table></div></div>',
        props: {
            historiesExtend: {
                default: function () {
                    return {};
                }
            }
        },
        data: function () {
            return {
                showSystem: false
            }
        },
        computed: {
            filterHistories: function () {
                if (this.historiesExtend.histories) {
                    if (this.showSystem) {
                        return this.historiesExtend.histories;
                    } else
                        return $.grep(this.historiesExtend.histories, function (item, index) {
                            return item.activityType == 'Task' || (item.batchId == "" && item.activityType == "End");
                        });
                }
            }
        },
        watch: {},
        created: function () {
            //子组件中需要增加v-if判断以结束递归
        },
        mounted: function () {
        },
        methods: {
            getHistoryState: function (history) {
                if (!history.finished)
                    return '待处理';
                if (history.actionType == 'Return')
                    return '已退回';
                if (history.actionType == 'Deliver')
                    return '已转交';
                return '已处理';
            }
        }
    });
});
