//流程引擎选择单个人员组件，使用树组件
define(['jquery', 'vue', 'peac-base-user'], function ($, Vue) {
    return Vue.component('pick-supplier-id-user', {
        props: {
            params: {default: ''}   //组件参数，指定组织
        },
        data: function () {
            return {
                permission: '',
                organizationId: '',
                userId: ''
            }
        },
        template: '<peac-base-user ref="comp" rest-url="/pms/account/v1/process-pick-user/getEmployeesByPermission"\
            :organization-id="organizationId" :user-id="userId" :permission="permission"></peac-base-user>',
        created: function () {
        },
        mounted: function () {
            this.loadData();
        },
        watch: {
            params: function (newValue, oldValue) {
                this.params = newValue;
                this.loadData();
            }
        },
        computed: {},
        methods: {
            setParams:function(params){
                if(params == undefined)
                    return;
                this.organizationId = params;
                this.loadData();
            },
            loadData: function () {
                //获取当前用户
                var that = this;
                $.ajax({
                    url: currentLoginUser,
                    type: "get",
                    contentType: "application/json;charset=UTF-8",
                    success: function (data) {
                        that.userId = data.data.accountId;
                        if (that.permission == '')
                            console.log('没有为pick-supplier-id-user组件指定param（权限）参数，组件将无数据显示。');
                    }
                });

            },
            verifyValue: function () {
                return this.$refs.comp.verifyValue();
            },
            getValue: function () {
                return this.$refs.comp.getValue();
            }
        }
    });
});
