//流程引擎选择单个人员组件，使用树组件
//根据 多个id  查取多个用户
define(['jquery', 'vue', 'peac-base-user'], function ($, Vue) {
    return Vue.component('pick-cmcc-role-user', {
        props: {
            params: {default: ''}   //组件参数，指定组织
        },
        data: function () {
            return {
                permission: '',
                organizationId: '',
                userId: ''
            }
        },
        template: '<peac-base-user ref="comp" rest-url="../../v1/process-pick-user/getCMCCByRole"\
            :organization-id="organizationId" :user-id="userId" :permission="permission"></peac-base-user>',
        created: function () {
        },
        mounted: function () {
            this.loadData();
        },
        watch: {
            params: function (newValue, oldValue) {
                this.params = newValue;
                this.loadData();
            }
        },
        computed: {},
        methods: {
            setParams:function(params){
                if(params == undefined)
                    return;
                this.permission = params;
                this.loadData();
            },
            loadData: function () {
                //获取当前用户
                var that = this;
                $.ajax({
                    url: getContextPath() + '/auth/current-department',
                    type: "get",
                    success: function (data) {
                        //that.permission = data.data.id;
                        that.organizationId = data.data.id;
                    }
                });

            },
            verifyValue: function () {
                return this.$refs.comp.verifyValue();
            },
            getValue: function () {
                return this.$refs.comp.getValue();
            }
        }
    });
});
