//流程引擎流程表达式选人
define(['jquery', 'vue', '../../libs/jquery.ztree/fuzzysearch.js', 'jquery-ztree']
    , function ($, Vue, fuzzySearch) {
        return Vue.component('peac-url-user-picker', {
            data: function () {
                return {
                    actorId: '',
                    domainId: '',
                    actorUrl: '',
                    selectedId: '',
                    selectedName: '',
                    selectedDepartmentName: '',
                    //已选择人员的文案
                    description: '择人员',
                    treeId: 'tree' + Math.floor(100000000 + Math.random() * 900000000),     //生成随机id
                    searchId: 'search' + Math.floor(100000000 + Math.random() * 900000000)  //生成随机id
                }
            },
            template: '<div>\
                        <div class="peac_column peac_column_tree" style="overflow: hidden;">\
                        <div class="peac_column_title">\
                        <!--<a href="javascript:void(null);" @click="expand">展开</a>-->\
                        <!--<a href="javascript:void(null);" @click="collapse">收起</a>-->\
                        <input type="text" :id="searchId" class="form_control" placeholder="请输入搜索内容" />\
                        </div>\
                        <div class="peac_tree_container">\
                            <ul :id="treeId" class="ztree"></ul>\
                        </div>\
                    </div>\
                    <div class="peac_column peac_column_selected">\
                        <div class="peac_column_title" style="line-height: 30px;">已选{{description}}</div>\
                        <div class="peac_selected_container">\
                            <div class="peac_selected_item" v-if="selectedId != \'\'">\
                                <div class="peac_selected_name">{{selectedName}}</div>\
                                <div class="peac_selected_remove" @click="clear">╳</div>\
                            </div>\
                        </div>\
                    </div>\
                    </div>',
            created: function () {
            },
            mounted: function () {
            },
            computed: {},
            methods: {
                setParams: function (actorUrl, actorId, domainId) {
                    if (actorUrl == undefined)
                        return;
                    this.actorUrl = actorUrl;
                    this.actorId = actorId;
                    this.domainId = domainId;
                    this.bindData();
                },
                bindData: function () {
                    var that = this;
                    var setting = {
                        check: {
                            enable: true,
                            chkStyle: 'radio',
                            radioType: 'all'
                        },
                        view: {showIcon: false},
                        callback: {
                            onClick: function (event, treeId, treeNode) {
                                var zTree = $.fn.zTree.getZTreeObj(treeId);
                                if (treeNode.isParent) {
                                    if (treeNode.open) {
                                        zTree.expandNode(treeNode, false);
                                    } else {
                                        zTree.expandNode(treeNode, true);
                                    }
                                } else {
                                    zTree.checkNode(treeNode, !treeNode.checked, true, true);
                                }
                            },
                            onCheck: function (event, treeId, treeNode) {
                                if (treeNode.checked) {
                                    that.selectedId = treeNode.id;
                                    that.selectedDepartmentName = treeNode.departmentName;
                                    that.selectedName = treeNode.name;
                                    if (treeNode.oldname)
                                        that.selectedName = treeNode.oldname;
                                } else {
                                    that.selectedId = '';
                                    that.selectedName = '';
                                    that.selectedDepartmentName = '';
                                }
                            }
                        }
                    };
                    if(that.actorUrl=='')
                        return;
                    $.ajax({
                        type: 'GET',
                        url: that.actorUrl,
                        data: {actorId: that.actorId, domainId: that.domainId},
                        success: function (res) {
                                var zNodes = res.data;
                                var zTreeObj = $.fn.zTree.init($('#' + that.treeId), setting, zNodes);    //绑定树
                                fuzzySearch.fuzzySearch(that.treeId, '#' + that.searchId, true, true);
                                //自动展开第一个根节点
                                if (zTreeObj.getNodes().length > 0)
                                    zTreeObj.expandNode(zTreeObj.getNodes()[0], true);
                        }
                    });
                },
                clear: function () {
                    this.selectedId = '';
                    this.selectedName = '';
                    this.selectedDepartmentName = '';
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    var nodes = treeObj.getCheckedNodes(true);
                    if (nodes.length > 0)
                        treeObj.checkNode(nodes[0], false);
                },
                expand: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.expandAll(true);
                },
                collapse: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.expandAll(false);
                },
                search: function () {
                    var treeObj = $.fn.zTree.getZTreeObj(this.treeId);
                    treeObj.fuzzySearch(false);
                },
                verifyValue: function () {
                    if (this.selectedId == '') {
                        alert('请选择处理人。');
                        return false;
                    }
                    return true;
                },
                getValue: function () {
                    var actor = this.selectedId + '::' + this.selectedName;
                    // if (this.selectedDepartmentName)
                    //     actor = actor + '（' + this.selectedDepartmentName + '）'
                    return actor;
                }
            }
        });
    });
