//流程引擎流程表达式取人
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('peac-script-user', {
        props: {
            params: {default: ''},      //参数，流程表达式
        },
        data: function () {
            return {
                script: this.params,
                actorName: '',
                actor: ''
            }
        },
        template: '<div class="peac_component_empty">\
                        <p>下一步处理人:{{actorName}}</p>\
                    </div>',
        created: function () {
        },
        mounted: function () {
            this.bindData();
        },
        watch: {
            script: function (newValue, oldValue) {
                this.bindData();
            },
            params: function (newValue, oldValue) {
                this.script = newValue;
                this.bindData();
            }
        },
        computed: {},
        methods: {
            setParams: function (params) {
                if (params == undefined)
                    return;
                this.script = params;
                this.bindData();
            },
            bindData: function () {
                var that = this;
                var restUrl = '/api/user/pe/by-expression';
                $.ajax({
                    dataType: 'JSON',
                    type: 'POST',
                    url: restUrl,
                    data: {script: that.script},
                    success: function (res) {
                        that.actor = res.data;
                        that.actorName = that.actor.split("::").length > 1 ? that.actor.split("::")[1] : '';
                    }
                });
            },
            verifyValue: function () {
                if (this.actor == '') {
                    // alert('未获取到处理人。');
                    layer.confirm('未获取到处理人。',
                        {title:'提示',btn: ['确定'],closeBtn: 0 },
                        function(index){
                            layer.close(index);
                        });
                    return false;
                }
                return true;
            },
            getValue: function () {
                return this.actor;
            }
        }
    });
});
