function getContextPath() {
    var pathName = document.location.pathname;
    var index = pathName.substr(1).indexOf("/");
    var result = pathName.substr(0, index + 1);
    return result;
}

function judgeEmpty(obj) {
    return obj == undefined || obj.length == 0;
}

function judgeNotEmpty(obj) {
    return !judgeEmpty(obj);
}

//require.js配置
require.config({
    urlArgs: "bust=1610415277336",
    baseUrl: '../../scripts',
    paths: {
        'jquery': ['../libs/jquery/jquery.min'],
        'jquery-ui': ['../libs/jquery-ui/jquery-ui.min'],
        'vue': ['../libs/vue/vue'],   //开发环境
        //'vue': ['../libs/vue/vue.min'],   //生产环境
        'vant': ['../libs/vant/vant'], // vant ui
        'listUtil': ['./listUtil'], // 处理树形结构数据
        'jquery-qtip': ['../libs/jquery.qtip/jquery.qtip.min'],
        'webuploader': ['../libs/webuploader/js/webuploader.min'],
        'layer': ['../libs/layer/layer'],
        'My97DatePicker': ['../libs/My97DatePicker/WdatePicker'],
        'Popper': ['../libs/popper/popper-bak'],
        'jquery-ztree': ['../libs/jquery.ztree/js/jquery.ztree.all'],
        'rem': ['./rem'],
        // 上传
        'component-uploader-mobile': ['../asset/js/mobile/component-uploader-mobile'],
        'component-upload-picture-mobile': ['../asset/js/mobile/component-upload-picture-mobile'],

        // popup选择弹框
        'component-popup-multi': ['../asset/js/mobile/component-popup-multi'],
        'component-popup-single': ['../asset/js/mobile/component-popup-single'],
        'process-engine-toolbar-v2': ['../asset/libs/process-engine-mobile-moa/component-process-engine-toolbar-v2'],
        'process-engine-history-extend-v2': ['../asset/libs/process-engine-mobile-moa/process-engine-history-extend-v2'],

        // 工作流组件
        'peac-user': ['../libs/process-engine/component-peac-user'],
        'peac-manager': ['../libs/process-engine/component-peac-manager'],
        'peac-user-tree': ['../libs/process-engine/component-peac-user-tree'],
        'peac-users-tree': ['../libs/process-engine/component-peac-users-tree'],

        'peac-base-user': ['../asset/libs/process-engine-mobile-moa/component-peac-base-user'],
        'peac-base-users': ['../asset/libs/process-engine-mobile-moa/component-peac-base-users'],

        //根据一组id  查询多个用户
        'pick-cmcc-id-user': ['../libs/process-engine/component-pick-cmcc-id-user'],

        //根据角色取人
        'pick-cmcc-role-user': ['../libs/process-engine/component-pick-cmcc-role-user'],
        'peac-url-user-picker': ['../asset/libs/process-engine-mobile-moa/component-peac-url-user-picker'],
    },
    shim: {
        'jquery-ui': {
            deps: ['jquery', 'css!../libs/jquery-ui/jquery-ui.min.css']
        },
        'jquery-ztree': {
            deps: ['jquery'
                //, 'css!../libs/jquery.ztree/css/awesomeStyle/awesome.css'
                //, 'css!../libs/jquery.ztree/css/metroStyle/metroStyle.css'
                , 'css!../libs/jquery.ztree/css/zTreeStyle/zTreeStyle.css'
            ]
        },
        'layer': {
            deps: ['jquery', 'css!../libs/layer/theme/default/layer.css']
            //, exports: 'layer'
        },
        'webuploader': {
            deps: ['jquery', 'css!../libs/webuploader/css/webuploader.css']
        },
        'vant': {
            deps: ['css!../libs/vant/vant.css']
        }
    },
    map: {
        '*': {
            'css': '../libs/require-css/css.min'
        }
    },
    waitSeconds: 0  //修复Load timeout for modules错误
});

//定义公共模块，应用程序中引用后会自动引用对应依赖模块
define("global",
    [
        'css!' + getContextPath() + '/asset/css/font_1520246_z6zu6e1hfqo/iconfont',
        'jquery',
        'jquery-ui',
        'jquery-ztree',
        'vue',
        'rem',
        //以上模块根据paths及shim配置加载
        //以下模块根据baseUrl配置自动加载
        'common',                       //公用脚本
        'common-config',        //服务地址配置
        'ajax-global',                  //ajax全局配置
        'new-id',                       //id生成工具
        'utils',                        //工具类
        'component-uploader-mobile',    //上传组件 - mobile
        'component-upload-picture-mobile', //上传组件 - mobile
        'process-engine-toolbar-v2',
        'process-engine-history-extend-v2',
        'peac-user',
        'peac-manager',
        'peac-user-tree',
        'peac-users-tree',
        'peac-base-user',
        'peac-base-users',
        'pick-cmcc-id-user',
        'pick-cmcc-role-user',
        'peac-url-user-picker',
    ]);
