//弹窗上传文件
define(['jquery', 'vue', 'webuploader'], function ($, Vue, WebUploader) {
    return Vue.component('uploader-mobile', {
        props: {
            //file-ids 文件id数组，v-model 实现双向绑定
            value: {
                default: function () {
                    return [];
                }
            },
            //上传按钮文字
            text: {default: '选择文件'},
            //最大上传数量
            maxCount: {default: undefined},
            //最大上传单文件大小
            maxFileSize: {default: undefined},
            //允许上传的文件格式
            accept: {default: undefined},
            //按钮样式
            buttonClass: {default: 'btn btn_upload'},
            placeHolder: {default: ''}
        },
        data: function () {
            return {
                id: undefined,                  //控件id
                uploader: undefined,            //WebUploader实例
                innerFiles: [],                 //文件内部变量
                multiple: this.maxCount != 1,   //是否多文件上传
                canFile: true,                  //是否返回文件
                currentFileId: '',              //当前文件id
                showPreviewModal: false,        //预览弹框
            }
        },
        template: '<div class="uploader_mobile_container">\
                        <div class="btn_uploader_mobile" :id="id">{{text}}</div>\
                        <ul>\
                            <li v-for="(file, index) in innerFiles" :id="file.id">\
                                <div class="info">\
                                    <p>{{file.name}}</p>\
                                    <p>{{autoUnitSize(file.size)}}</p>\
                                </div>\
                                <van-icon name="cross" @click="deleteFile(file, index)"></van-icon>\
                                <div class="process"></div>\
                            </li>\
                        </ul>\
                    </div>',
        created: function () {
            //生成guid，此id用于创建WebUploader实例时关联pick，以保证页面上有多个组件时互相隔离
            //采用layer前缀
            this.id = WebUploader.Base.guid("");
        },
        mounted: function () {
            // //根据filesId获取文件
            this.upload();
        },
        watch: {
            value: {
                handler: function (val, oldVal) {
                    //如果指定了filesId，根据filesId获取文件
                    if ($.isArray(val) && val.length > 0) {
                        var ids = $.map(this.innerFiles, function (value, index) {
                            return value.id;
                        })
                        if (!this.compareArray(val, ids))
                            this.setFiles(val);
                    } else {
                        this.innerFiles = [];
                    }
                }, immediate: true
            }
        },
        computed: {
            //是否有文件
            hasFile: function () {
                var that = this;
                if (that.uploader)
                    that.uploader.refresh();
                if (that.innerFiles == null || that.innerFiles.length < 1)
                    return false
                return true;
            },
            fileNames: function () {
                var names = $.map(this.innerFiles, function (value, index) {
                    return value.name;
                })
                return names.join('、');
            }
        },
        methods: {
            upload: function () {
                this.uploader = WebUploader.create({
                    swf: '../../libs/webuploader-0.1.5/js/Uploader.swf',
                    server: fileStoreServer + '/api/upload',
                    method: 'POST',
                    pick: {id: '#' + this.id, multiple: this.multiple},
                    resize: false,                  //不压缩image, 默认如果是jpeg，文件上传前会进行压缩
                    auto: true,                     //选择文件后自动上传
                    duplicate: true,                //允许选择重复文件
                    fileNumLimit: this.maxCount,    //允许最多文件个数
                    fileSingleSizeLimit: this.maxFileSize,    //验证单个文件大小是否超出限制, 超出则不允许加入队列。
                    accept: this.accept             //限制文件类型
                });
                var that = this;
                if (that.uploader != null) {
                    //当文件被加入队列之前触发，此事件的handler返回值为false，则此文件不会被添加进入队列
                    this.uploader.on('beforeFileQueued', function (file) {
                        //修改为在error方法中判断
                        if (that.maxCount != undefined) {
                            if (that.innerFiles.length >= that.maxCount) {
                                //alert会弹出多次，改用layer显示
                                that.$toast.fail('最多只允许上传' + that.maxCount + '个文件。');
                                return false;
                            }
                        }


                        // 可以上传的文件类型 'doc,docx'
                        if (that.accept && that.accept.split(',').indexOf(file.ext) == -1) {
                            that.$toast.fail("只允许上传“" + that.accept + "”格式文件。"); //验证文件格式
                            return false
                        }

                    });

                    // 当文件被加入队列以后触发
                    that.uploader.on('fileQueued', function (file) {
                        that.innerFiles.splice(0, 0, file);  //将上传文件加入集合
                        that.$nextTick(function () {
                            $('#' + file.id + " .process").css('display', 'block');
                        });
                    });

                    // 上传过程中触发，携带上传进度
                    that.uploader.on('uploadProgress', function (file, percentage) {
                        console.log('percentage', percentage)
                        $('#' + file.id + " .process").css('width', percentage * 100 + '%');
                    });

                    // 当文件上传成功时触发
                    that.uploader.on('uploadSuccess', function (file, response) {
                        if (!response.isSuccess) {
                            that.$toast.success(response.message);
                            $('#' + file.id + ' .process').hide();  //隐藏进度条
                            var index = that.innerFiles.indexOf(file);
                            that.innerFiles.splice(index, 1);               //上从集合中删除文件
                            //移除组件中文件，否则计算已上传文件数量时有误
                            if (that.uploader.getFiles().indexOf(file) != -1)
                                that.uploader.removeFile(file, true);   //移除某一文件, 默认只会标记文件状态为已取消，如果第二个参数为true则会从queue中移除
                        } else {
                            $('#' + file.id + ' .process').hide();
                            that.$set(file, 'id', response.data.id)               //上传成功时更新文件id
                            //添加回调方法
                            that.$emit('after-upload', response.data);
                        }
                        that.getFilesId();
                    });

                    that.uploader.on("error", function (type) {
                        if (type == "Q_TYPE_DENIED") {
                            that.$toast.fail("文件不能为空。");
                            if (typeof that.accept != 'undefined')
                                that.$toast.fail("只允许上传“" + that.accept.extensions + "”格式文件。");//验证文件格式
                        } else if (type == "F_EXCEED_SIZE") {
                            that.$toast.fail("单文件大小不能超过" + that.autoUnitSize(that.maxFileSize)); //验证文件大小
                        } else if (type == "Q_EXCEED_NUM_LIMIT") {
                            that.$toast.fail("最多只允许上传" + that.maxCount + "个文件。");//验证文件数量
                        } else {
                            that.$toast.fail("上传文件时发生错误：" + type);
                        }
                    });

                    that.uploader.on('uploadError', function (file, reason) {
                        that.$toast.fail("上传文件时发生错误：" + reason);
                        $('#' + file.id + ' .process').hide();  //隐藏进度条
                        var index = that.innerFiles.indexOf(file);
                        that.innerFiles.splice(index, 1);                   //从集合中删除文件
                        //移除组件中文件，否则计算已上传文件数量时有误
                        if (that.uploader.getFiles().indexOf(file) != -1)
                            that.uploader.removeFile(file, true);   //移除某一文件, 默认只会标记文件状态为已取消，如果第二个参数为true则会从queue中移除
                        that.getFilesId();
                    });
                }
            },
            setFiles: function (filesId) {
                var that = this;
                if (filesId.length > 0) {
                    $.ajax({
                        async: false,
                        type: 'POST',
                        url: fileStoreServer + '/api/query-by-ids',
                        data: JSON.stringify(filesId),
                        contentType: 'application/json;charset=utf-8',
                        success: function (data) {
                            if (!data.isSuccess) return;
                            that.innerFiles = data.data
                        }
                    });
                }
            },
            // 删除图片
            deleteFile: function (file, index) {
                var that = this;
                if (that.hasFile) {
                    this.innerFiles.splice(index, 1);
                    //移除组件中文件，否则计算已上传文件数量时有误
                    if (this.uploader.getFiles().indexOf(file) != -1)
                        this.uploader.removeFile(file, true);   //移除某一文件, 默认只会标记文件状态为已取消，如果第二个参数为true则会从queue中移除
                    this.getFilesId();
                    that.upload();
                }
            },
            getFiles: function () {
                return this.innerFiles;
            },
            getFilesId: function () {
                var ids = $.map(this.innerFiles, function (value, index) {
                    return value.id;
                })
                this.canFile = false;
                this.$emit('input', ids);
                return ids;
            },
            //根据文件大小自动选择单位显示
            autoUnitSize: function (size) {
                return WebUploader.Base.formatSize(size);
            },
            //根据文件后缀名判断文件类型
            fileClass: function (filename) {
                //获取最后一个.的位置
                var index = filename.lastIndexOf(".");
                //获取后缀
                var ext = filename.substr(index + 1);
                if (ext.indexOf('doc') > -1)
                    return 'file_word';
                else if (ext.indexOf('xls') > -1)
                    return 'file_excel';
                else if (ext.indexOf('ppt') > -1)
                    return 'file_ppt';
                else if (ext.indexOf('pdf') > -1)
                    return 'file_pdf';
                else if (ext.indexOf('txt') > -1)
                    return 'file_txt';
                else if (['zip', 'rar', '7z'].indexOf(ext) > -1)
                    return 'file_zip';
                else if (['bmp', 'jpg', 'png', 'gif', 'jpeg'].indexOf(ext) > -1)
                    return 'file_png';
                else
                    return 'file_unknow';
            },
            // 比较数组是否相同
            compareArray: function (arr1, arr2) {
                if (arr1.length != arr2.length)
                    return false

                if (arr1.length == arr2.length) {
                    for (var i = 0; i < arr1.length; i++) {
                        var index = arr2.indexOf(arr1[i].toString())
                        if (index == -1) {
                            return false;
                        }
                    }
                }
                return true
            },
        }
    });
});
