package com.infoepoch.pms.dispatchassistant.infractructure.system.dict;

import com.infoepoch.pms.dispatchassistant.domain.system.dict.IDictTypeRepository;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.SystemDictCriteria;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.SystemDictType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

@Repository
public class DictTypeRepository implements IDictTypeRepository {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public List<SystemDictType> selectByCriteria(SystemDictCriteria criteria) {
        String baseSql = "SELECT TEMP.* FROM(SELECT ROWNUM R,V.* FROM (SELECT * FROM SYS_DICT_TYPE WHERE 1=1";
        List<Object> paramList = new ArrayList<>();
        StringBuilder sql = transferCriteria(baseSql, criteria, paramList);
        sql.append(" ORDER BY DT_CREATE_TIME DESC");
        sql.append(") V) TEMP");
        if (criteria.isPaginationFlag()) {
            sql.append(" WHERE TEMP.R BETWEEN ? AND ?");
            paramList.add(criteria.startIndex());
            paramList.add(criteria.endIndex());
        }
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet(sql.toString(), paramList.toArray());
        List<SystemDictType> dictTypeList = new ArrayList<>();
        while (sqlRowSet.next())
            dictTypeList.add(convert(sqlRowSet));
        return dictTypeList;
    }

    @Override
    public int selectByCriteriaCount(SystemDictCriteria criteria) {
        String baseSql = "SELECT COUNT(1) FROM (SELECT * FROM SYS_DICT_TYPE WHERE 1=1";
        List<Object> paramList = new ArrayList<>();
        StringBuilder sql = transferCriteria(baseSql, criteria, paramList);
        sql.append(") V");
        return jdbcTemplate.queryForObject(sql.toString(), paramList.toArray(), int.class);
    }

    @Override
    public SystemDictType selectById(String id) {
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT * FROM SYS_DICT_TYPE WHERE DT_ID = ?", id);
        if (sqlRowSet.next())
            return convert(sqlRowSet);
        return null;
    }

    @Override
    public SystemDictType selectByType(String dictType) {
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT * FROM SYS_DICT_TYPE WHERE DT_DICT_TYPE = ?", dictType);
        if (sqlRowSet.next())
            return convert(sqlRowSet);
        return null;
    }

    @Override
    public void insert(SystemDictType dictType) {
        String sql = "INSERT INTO SYS_DICT_TYPE(DT_ID,DT_NAME,DT_DICT_TYPE,DT_STATUS,DT_CREATE_BY,DT_CREATE_TIME,DT_UPDATE_BY," +
                "DT_UPDATE_TIME,DT_REMARK) VALUES(?,?,?,?,?,?,?,?,?)";
        jdbcTemplate.update(sql,
                dictType.getId(),
                dictType.getName(),
                dictType.getDictType(),
                dictType.getStatus(),
                dictType.getCreateBy(),
                dictType.getCreateTime(),
                dictType.getUpdateBy(),
                dictType.getUpdateTime(),
                dictType.getRemark()
        );
    }

    @Override
    public void update(SystemDictType dictType) {
        String sql = "UPDATE SYS_DICT_TYPE SET DT_NAME=?,DT_DICT_TYPE=?,DT_STATUS=?,DT_CREATE_BY=?,DT_CREATE_TIME=?," +
                "DT_UPDATE_BY=?,DT_UPDATE_TIME=?,DT_REMARK=? WHERE DT_ID = ?";
        jdbcTemplate.update(sql,
                dictType.getName(),
                dictType.getDictType(),
                dictType.getStatus(),
                dictType.getCreateBy(),
                dictType.getCreateTime(),
                dictType.getUpdateBy(),
                dictType.getUpdateTime(),
                dictType.getRemark(),
                dictType.getId()
        );
    }

    @Override
    public void softDeleteById(String id) {
        jdbcTemplate.update("UPDATE SYS_DICT_TYPE SET DT_STATUS = 2 WHERE DT_ID = ?", id);
    }

    @Override
    public void deleteById(String id) {
        jdbcTemplate.update("DELETE FROM SYS_DICT_TYPE WHERE DT_ID = ?", id);
    }

    /**
     * 查询条件转换
     *
     * @param baseSql
     * @param criteria
     * @param paramList
     * @return
     */
    private StringBuilder transferCriteria(String baseSql, SystemDictCriteria criteria, List<Object> paramList) {
        StringBuilder sql = new StringBuilder(baseSql);
        if (StringUtils.isNotBlank(criteria.getDictType())) {
            sql.append(" AND DT_DICT_TYPE = ?");
            paramList.add(criteria.getDictType());
        }
        if (StringUtils.isNotBlank(criteria.getName())) {
            sql.append(" AND DT_NAME LIKE ?");
            paramList.add("%" + criteria.getName() + "%");
        }
        if(criteria.getStatus() == null) {
            sql.append(" AND DT_STATUS != 2");
        } else {
            sql.append(" AND DT_STATUS = ?");
            paramList.add(criteria.getStatus());
        }
        return sql;
    }

    /**
     * 查询结果集转换
     *
     * @param sqlRowSet
     * @return
     */
    private SystemDictType convert(SqlRowSet sqlRowSet) {
        return new SystemDictType(
                sqlRowSet.getString("DT_ID"),
                sqlRowSet.getString("DT_NAME"),
                sqlRowSet.getString("DT_DICT_TYPE"),
                sqlRowSet.getInt("DT_STATUS"),
                sqlRowSet.getString("DT_CREATE_BY"),
                sqlRowSet.getTimestamp("DT_CREATE_TIME"),
                sqlRowSet.getString("DT_UPDATE_BY"),
                sqlRowSet.getTimestamp("DT_UPDATE_TIME"),
                sqlRowSet.getString("DT_REMARK")
        );
    }
}
