package com.infoepoch.pms.dispatchassistant.domain.system.uploadFile;

import java.util.List;

/**
* 上传文件记录表仓储接口
*/
public interface IUploadFileRepository {
    /**
     * 新增
     * @param: [entity]
     */
    boolean insert(UploadFile entity);

    /**
     * 更新
     * @param: [entity]
     */
    boolean update(UploadFile entity);

    /**
     * 批量新增
     * @param: [entitys]
     */
    int[] batchInsert(List<UploadFile> entitys);

    /**
     * 批量更新
     * @param: [entitys]
     */
    int[] batchUpdate(List<UploadFile> entitys);

    /**
     * 删除
     * @param: [id]
     */
    boolean delete(String id);

    // region select

    /**
     * 根据Id查询
     * @param: [id]
     */
    UploadFile selectById(String id);

    /**
     * 根据一组id查询上传文件
     */
    List<UploadFile> selectByIds(List<String> ids);

    /**
     * 根据查询条件查询单个对象
     * @param: [criteria]
     */
    UploadFile selectOneByCriteria(UploadFileCriteria criteria);

    /**
     * 根据查询条件查询对象集合
     * @param: [criteria]
     */
    List<UploadFile> selectByCriteria(UploadFileCriteria criteria);

    /**
     * 根据查询条件分页查询对象结合
     * @param: [criteria, pageIndex, pageSize]
     */
    List<UploadFile> selectCriteriaByPage(UploadFileCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询对象总记录数
     * @param: [criteria]
     */
    int selectCountByCriteria(UploadFileCriteria criteria);

    // endregion
}
