package com.infoepoch.pms.dispatchassistant.domain.system.moaLog;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;
import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * MOA日志记录表
 */
public class MoaLog {

    // region

    public void setActionFlag(Boolean actionFlag) {
        this.actionFlag = actionFlag;
    }


    // endregion

    // region 校验

    /**
     * 校验
     */
    public void verify() {
        if (StringUtils.isBlank(this.businessModule))
            throw new ValidationException("业务模块不可为空");
        if (StringUtils.isBlank(this.url))
            throw new ValidationException("URL地址不可为空");
        if (StringUtils.isBlank(this.domainId))
            throw new ValidationException("领域ID不可为空");
    }

    // endregion 校验

    // region 新增&修改

    /**
     * 新增
     *
     * @param userId
     * @param userName
     */
    public void add(String userId, String userName) {
        this.id = SnowFlake.instant().nextId().toString();
        this.createTime = new Date();
        this.userId = userId;
        this.userName = userName;
    }

    // endregion 新增&修改
    // region 构造方法

    /**
     * 私有无参构造
     */
    private MoaLog() {
    }

    /**
     * 仓储还原
     */
    public MoaLog(String id, String type, String businessModule, String url, Boolean actionFlag, Date createTime, String userId,
                  String userName, String domainId, String stage) {
        this.id = id;
        this.type = type;
        this.businessModule = businessModule;
        this.url = url;
        this.actionFlag = actionFlag;
        this.createTime = createTime;
        this.userId = userId;
        this.userName = userName;
        this.domainId = domainId;
        this.stage = stage;
    }

    // endregion 构造方法
    // region 基础属性

    /**
     * 主键
     */
    private String id;
    /**
     * 类型
     */
    private String type;
    /**
     * 业务模块
     */
    private String businessModule;
    /**
     * url地址
     */
    private String url;
    /**
     * 处理标识：1-处理成功 0-处理失败
     */
    private Boolean actionFlag;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 当前登录用户ID
     */
    private String userId;
    /**
     * 当前登录用户名称
     */
    private String userName;
    /**
     * 领域ID
     */
    private String domainId;
    /**
     * 流程步骤
     */
    private String stage;

    public String getId() {
        return id;
    }

    public String getType() {
        return type;
    }

    public String getBusinessModule() {
        return businessModule;
    }

    public String getUrl() {
        return url;
    }

    public Boolean getActionFlag() {
        return actionFlag;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getUserId() {
        return userId;
    }

    public String getUserName() {
        return userName;
    }

    public String getDomainId() {
        return domainId;
    }

    public String getStage() {
        return stage;
    }

    // endregion 基础属性

}
