package com.infoepoch.pms.dispatchassistant.domain.system.dict;


import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;

import java.util.Date;

/**
 * 系统字典值
 */
public class SystemDictData {

    public void update(String userName) {
        this.updateBy = userName;
        this.updateTime = new Date();
    }

    /**
     * 新增
     *
     * @param userName
     */
    public void create(String userName) {
        this.id = SnowFlake.instant().nextId().toString();
        this.status = 0;
        this.createBy = userName;
        this.createTime = new Date();
    }

    /**
     * 修改
     *
     * @param sort
     * @param label
     * @param value
     * @param cssClass
     * @param listClass
     * @param defaultFlag
     * @param userName
     */
    public void modify(Integer sort, String label, String value, String cssClass, String listClass, Integer defaultFlag, String userName) {
        this.sort = sort;
        this.label = label;
        this.value = value;
        this.cssClass = cssClass;
        this.listClass = listClass;
        this.defaultFlag = defaultFlag;
        this.updateBy = userName;
        this.updateTime = new Date();
    }

    public SystemDictData() {
    }

    /**
     * 仓储还原
     */
    public SystemDictData(String id, String dictType, Integer sort, String label, String value, String cssClass, String listClass,
                          Integer defaultFlag, Integer status, String createBy, Date createTime, String updateBy, Date updateTime,
                          String remark) {
        this.id = id;
        this.dictType = dictType;
        this.sort = sort;
        this.label = label;
        this.value = value;
        this.cssClass = cssClass;
        this.listClass = listClass;
        this.defaultFlag = defaultFlag;
        this.status = status;
        this.createBy = createBy;
        this.createTime = createTime;
        this.updateBy = updateBy;
        this.updateTime = updateTime;
        this.remark = remark;
    }

    private String id;
    // 字典类型
    private String dictType;
    // 排序
    private Integer sort;
    // 显示文本
    private String label;
    // 字典值
    private String value;
    // css样式
    private String cssClass;
    // 列表样式
    private String listClass;
    // 默认值标识
    private Integer defaultFlag;
    // 状态
    private Integer status;
    // 创建人
    private String createBy;
    // 创建时间
    private Date createTime;
    // 更新人
    private String updateBy;
    // 更新时间
    private Date updateTime;
    // 备注
    private String remark;

    public String getId() {
        return id;
    }

    public String getDictType() {
        return dictType;
    }

    public Integer getSort() {
        return sort;
    }

    public String getLabel() {
        return label;
    }

    public String getValue() {
        return value;
    }

    public String getCssClass() {
        return cssClass;
    }

    public String getListClass() {
        return listClass;
    }

    public Integer getDefaultFlag() {
        return defaultFlag;
    }

    public Integer getStatus() {
        return status;
    }

    public String getCreateBy() {
        return createBy;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public String getRemark() {
        return remark;
    }
}
