package com.infoepoch.pms.dispatchassistant.domain.oa.user;

import java.util.List;

/**
* OA用户PMS仓储接口
*/
public interface IUserPmsRepository {
    /**
     * 新增
     * @param: [entity]
     */
    boolean insert(UserPms entity);

    /**
     * 更新
     * @param: [entity]
     */
    boolean update(UserPms entity);

    /**
     * 批量新增
     * @param: [entitys]
     */
    int[] batchInsert(List<UserPms> entitys);

    /**
     * 批量更新
     * @param: [entitys]
     */
    int[] batchUpdate(List<UserPms> entitys);

    /**
     * 删除
     * @param: [id]
     */
    boolean delete(String id);

    /**
     *
     * @param employeeNumber
     * @return
     */
    boolean deleteByEmployeeNumber(String employeeNumber);

    // region select

    /**
     * 根据Id查询
     * @param: [id]
     */
    UserPms selectById(String id);

    /**
     * 根据查询条件查询单个对象
     * @param: [criteria]
     */
    UserPms selectOneByCriteria(UserPmsCriteria criteria);

    /**
     * 根据查询条件查询对象集合
     * @param: [criteria]
     */
    List<UserPms> selectByCriteria(UserPmsCriteria criteria);

    /**
     * 根据查询条件分页查询对象结合
     * @param: [criteria, pageIndex, pageSize]
     */
    List<UserPms> selectCriteriaByPage(UserPmsCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询对象总记录数
     * @param: [criteria]
     */
    int selectCountByCriteria(UserPmsCriteria criteria);

    /**
     *
     * @param reference2
     * @return
     */
    List<UserPms> selectByReference2(String reference2);

    /**
     *
     * @param reference3
     * @return
     */
    List<UserPms> selectByReference3(String reference3);

    // endregion
}
