package com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation.line.history;

import java.util.List;

public interface IConversationLineHistoryRepository {

    /**
     * 插入
     *
     * @param entity
     */
    void insert(ConversationLineHistory entity);

    /**
     * 批量插入
     *
     * @param list
     */
    void batchInsert(List<ConversationLineHistory> list);

    /**
     * 更新
     *
     * @param entity
     */
    void update(ConversationLineHistory entity);

    /**
     * 批量更新
     *
     * @param list
     */
    void batchUpdate(List<ConversationLineHistory> list);

    // region 查询

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    ConversationLineHistory selectById(String id);

    /**
     * 根据条件查询列表
     *
     * @param criteria
     * @return
     */
    List<ConversationLineHistory> selectByCriteria(ConversationLineHistoryCriteria criteria);

    /**
     * 根据条件分页查询列表
     *
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<ConversationLineHistory> selectByCriteriaPage(ConversationLineHistoryCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询列表总数量
     *
     * @param criteria
     * @return
     */
    int selectByCriteriaCount(ConversationLineHistoryCriteria criteria);

    // endregion 查询

}
