package com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation;


import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;

import java.util.Date;

public class Conversation {

    /**
     * 修改最后一次聊天时间
     *
     * @param lastChatTime
     */
    public void modifyLastChatTime(Date lastChatTime) {
        this.lastChatTime = lastChatTime;
    }

    /**
     * 新增
     *
     * @param userId
     * @param userName
     */
    public void create(String userId, String userName) {
        this.id = SnowFlake.instant().nextId().toString();
        this.userId = userId;
        this.userName = userName;
        this.createTime = new Date();
        this.lastChatTime = new Date();
    }

    /**
     * 新增
     *
     * @param userId
     * @param userName
     * @param type
     * @return
     */
    public static Conversation create(String userId, String userName, String type) {
        return new Conversation(
                SnowFlake.instant().nextId().toString(),
                new Date(),
                userId,
                userName,
                type,
                new Date()
        );
    }

    public Conversation() {
    }

    /**
     * 仓储还原
     *
     * @param id
     * @param createTime
     * @param userId
     * @param userName
     * @param type
     * @param lastChatTime
     */
    public Conversation(String id, Date createTime, String userId, String userName, String type, Date lastChatTime) {
        this.id = id;
        this.createTime = createTime;
        this.userId = userId;
        this.userName = userName;
        this.type = type;
        this.lastChatTime = lastChatTime;
    }

    private String id;
    private Date createTime;
    private String userId;
    private String userName;
    private String type;
    private Date lastChatTime;

    public String getId() {
        return id;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getUserId() {
        return userId;
    }

    public String getUserName() {
        return userName;
    }

    public String getType() {
        return type;
    }

    public Date getLastChatTime() {
        return lastChatTime;
    }
}
