package com.infoepoch.pms.dispatchassistant.domain.langchain.chat.feedback;



import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import io.micrometer.core.instrument.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

public class FeedbackRequest {

    public void verify() {
        if(StringUtils.isBlank(this.messageId))
            throw new ValidationException("消息ID不可为空");
        if(this.score == null)
            throw new ValidationException("评分不可为空");
        if(StringUtils.isBlank(this.reason))
            throw new ValidationException("反馈原因不可为空");
    }

    public Map<String,Object> toMap() {
        this.verify();
        Map<String,Object> map = new HashMap<>();
        map.put("message_id", this.messageId);
        map.put("score", this.score);
        map.put("reason", this.reason);
        return map;
    }

    /**
     * 私有化无参构造
     */
    private FeedbackRequest() {
    }

    /**
     * 新增
     *
     * @param messageId
     * @param score
     * @param reason
     */
    public FeedbackRequest(String messageId, Integer score, String reason) {
        this.messageId = messageId;
        this.score = score;
        this.reason = reason;
    }

    private String messageId;
    private Integer score;
    private String reason;

}
