package com.infoepoch.pms.dispatchassistant.domain.expertInformation;


import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import com.infoepoch.pms.dispatchassistant.common.utils.StringUtils;
import com.infoepoch.pms.dispatchassistant.infractructure.langchain.ConversationsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Service;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * generated by code-generator
 * 专家信息表Service
 **/
@Service
public class ExpertInformationService {
    @Autowired
    private IExpertInformationRepository repository;
    private static final Logger LogHelper = LoggerFactory.getLogger(ConversationsRepository.class);


    /**
     * 根据条件查询单个对象
     **/
    public ExpertInformation querySingle( ExpertInformationCriteria criteria) {
        criteria.removeMapNullOrEmpty();
        ExpertInformation entity;
        try {
            entity = repository.selectOneByCriteria(criteria);
            return entity;
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            throw new ValidationException("根据条件查询专家信息表 数据 失败。");
        }
    }

    /**
     * 根据id查询
     **/
    public ExpertInformation queryById(String id) {
        if (StringUtils.isBlank(id)){
            throw new ValidationException("唯一标识不能为空");
        };
        ExpertInformation entity;
        try {
            entity = repository.selectById(id);
            return entity;
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            throw new ValidationException("根据id查询 专家信息表 数据 失败。");
        }
    }

    /**
     * 根据条件查询列表（可分页）
     **/
    public Map<String, Object> queryList( ExpertInformationCriteria criteria) {
        try {
            criteria.removeMapNullOrEmpty();
            if (criteria.byPage()) {
                List<ExpertInformation> entityList = repository.selectCriteriaByPage(criteria, criteria.getPageSize(), criteria.getPageSize());
                int totalCount = repository.selectCountByCriteria(criteria);
                Map<String, Object> map = new HashMap<>();
                map.put("totalCount", totalCount);
                map.put("entityList", entityList);
                return map;
            } else {
                if (!criteria.hasCriteria())
                    throw new ValidationException("请输入查询条件。");
                return null;
            }
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            throw new ValidationException("根据条件查询 专家信息表 列表 数据 失败。");
        }
    }


    /**
     * 根据条件查询列表
     **/
    public Map<String, Object> selectExpertInformation( ExpertInformationCriteria criteria) {
        try {
            criteria.removeMapNullOrEmpty();
            Map<String, Object> map = new HashMap<>();
            if(StringUtils.isEmpty(criteria.getExpertType()))
            {
                if(criteria.getPageSize()==null||criteria.getPageSize()==0)
                    criteria.setPageSize(10);
                List<Map<String,Object>> entityList = repository.selectExpertByPage(criteria,1,criteria.getPageSize());
                map.put("entityList", entityList);
                return map;
            }else {
                //内部专家
                if("a".equals(criteria.getExpertType())) {
                    if(criteria.getPageSize()==null||criteria.getPageSize()==0)
                        criteria.setPageSize(10);
                    List<Map<String,Object>> entityList = repository.selectExpertByPage(criteria,1,criteria.getPageSize());
                    map.put("entityList", entityList);
                    return map;
                }
                //外部专家
                if("b".equals(criteria.getExpertType())) {
                    if(criteria.getPageSize()==null||criteria.getPageSize()==0)
                        criteria.setPageSize(10);
                    List<Map<String,Object>> entityList = repository.selectExpertOutByPage(criteria,1,criteria.getPageSize());
                    map.put("entityList", entityList);
                    return map;
                }
            }
            return map;
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            throw new ValidationException("根据条件查询 专家信息表 列表 数据 失败。");
        }
    }

    /**
     * 根据条件查询列表
     **/
    public Map<String, Object> selectExternalExpertInformation( ExpertInformationCriteria criteria) {
        try {
            criteria.removeMapNullOrEmpty();
            Map<String, Object> map = new HashMap<>();
            if(criteria.getPageSize()==null||criteria.getPageSize()==0)
                criteria.setPageSize(10);
            List<Map<String,Object>> entityList = repository.selectExpertOutByPage(criteria,1,criteria.getPageSize());
            map.put("entityList", entityList);
            return map;
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            throw new ValidationException("根据条件查询 专家信息表 列表 数据 失败。");
        }
    }

    /**
     * 保存
     **/
    public boolean save( ExpertInformation entity) {
        try {
            entity.verify();
            boolean insert = repository.insert(entity);
            return insert;
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            throw new ValidationException("保存 专家信息表 数据 失败。");
        }
    }

    /**
     * 修改
     **/
    public boolean modify( ExpertInformation entity) {
        try {
            entity.verify();
            boolean update = repository.update(entity);
            return update;
        } catch (Exception e) {
            LogHelper.info(e.getMessage());
            throw new ValidationException("修改 专家信息表 数据 失败。");
        }
    }
}

