package com.infoepoch.pms.dispatchassistant.domain.expertInformation;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * generated by code-generator
 * 专家信息表
 */
public class ExpertInformation {

    /**
     * 专家ID
     */
    private Integer id;
    /**
     * 专家姓名
     */
    private String name;
    /**
     * 专家性别
     */
    private String gender;
    /**
     * 专家邮箱
     */
    private String mailbox;
    /**
     * 专家电话
     */
    private String telephone;
    /**
     * 专家OA用户名
     */
    private String userName;
    /**
     * 入职时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date employmentDate;
    /**
     * 专家部门
     */
    private String department;
    /**
     * 专家科室
     */
    private String group;
    /**
     * 职位
     */
    private String position;
    /**
     * 业务范围
     */
    private String scopeBusiness;
    /**
     * 调用状态
     */
    private String state;
    /**
     * 擅长领域
     */
    private String specializesFields;
    /**
     * 专家简介
     */
    private String expertIntroduction;
    /**
     * 所属OA组织编码
     */
    private String organizationalCode;
    /**
     * 记录时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date recordTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    /**
     * 专家照片
     */
    private String photo;
    /**
     * 专家科室ID
     */
    private Long groupId;
    /**
     * 专家部门ID
     */
    private Long departmentId;
    /**
     * 专家用户ID
     */
    private Long userId;
    /**
     * 专家满意度均分
     */
    private BigDecimal satisfactionScore;
    /**
     * 专家职称
     */
    private String level;
    /**
     * 专家是否启用(1是启用，0是禁用，2是冻结)
     */
    private String disabled;
    /**
     * 所属地市
     */
    private String regionCode;
    /**
     * 排序
     */
    private Integer sort;

    /**
     * 私有无参构造
     */
    private ExpertInformation() {
    }

    /**
     * 仓储还原
     */
    public ExpertInformation(Integer id, String name, String gender, String mailbox, String telephone, String userName, Date employmentDate, String department, String group, String position, String scopeBusiness, String state, String specializesFields, String expertIntroduction, String organizationalCode, Date recordTime, Date updateTime, String photo, Long groupId, Long departmentId, Long userId, BigDecimal satisfactionScore, String level, String disabled, String regionCode, Integer sort) {
        this.id = id;
        this.name = name;
        this.gender = gender;
        this.mailbox = mailbox;
        this.telephone = telephone;
        this.userName = userName;
        this.employmentDate = employmentDate;
        this.department = department;
        this.group = group;
        this.position = position;
        this.scopeBusiness = scopeBusiness;
        this.state = state;
        this.specializesFields = specializesFields;
        this.expertIntroduction = expertIntroduction;
        this.organizationalCode = organizationalCode;
        this.recordTime = recordTime;
        this.updateTime = updateTime;
        this.photo = photo;
        this.groupId = groupId;
        this.departmentId = departmentId;
        this.userId = userId;
        this.satisfactionScore = satisfactionScore;
        this.level = level;
        this.disabled = disabled;
        this.regionCode = regionCode;
        this.sort = sort;
    }

    /**
     * 校验
     */
    public void verify() {
    }
    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getGender() {
        return gender;
    }

    public String getMailbox() {
        return mailbox;
    }

    public String getTelephone() {
        return telephone;
    }

    public String getUserName() {
        return userName;
    }

    public Date getEmploymentDate() {
        return employmentDate;
    }

    public String getDepartment() {
        return department;
    }

    public String getGroup() {
        return group;
    }

    public String getPosition() {
        return position;
    }

    public String getScopeBusiness() {
        return scopeBusiness;
    }

    public String getState() {
        return state;
    }

    public String getSpecializesFields() {
        return specializesFields;
    }

    public String getExpertIntroduction() {
        return expertIntroduction;
    }

    public String getOrganizationalCode() {
        return organizationalCode;
    }

    public Date getRecordTime() {
        return recordTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public String getPhoto() {
        return photo;
    }

    public Long getGroupId() {
        return groupId;
    }

// This method returns the departmentId
    public Long getDepartmentId() {
        return departmentId;
    }

    public Long getUserId() {
        return userId;
    }

    public BigDecimal getSatisfactionScore() {
        return satisfactionScore;
    }

    public String getLevel() {
        return level;
    }

    public String getDisabled() {
        return disabled;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public Integer getSort() {
        return sort;
    }

}
