package com.infoepoch.pms.dispatchassistant.domain.basic.user.organizationRela;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;
import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * 用户与组织关联表
 */
public class UserOrganizationRela {

    public void setRecordTime(Date recordTime) {
        this.recordTime = recordTime;
    }

    // region 校验

    /**
     * 校验
     */
    public void verify() {
        if (StringUtils.isBlank(userId))
            throw new ValidationException("用户ID不能为空");
        if (StringUtils.isBlank(organizationId))
            throw new ValidationException("组织ID不能为空");
        if (StringUtils.isBlank(position))
            throw new ValidationException("职位不能为空");
        if (majorPositionFlag == null)
            throw new ValidationException("是否主职位不能为空");

    }

    // endregion 校验

    // region 新增&修改

    /**
     * 初始化Id
     */
    public void initializePk() {
        if (StringUtils.isBlank(this.id))
            this.id = String.valueOf(SnowFlake.instant().nextId());
        this.recordTime = new Date();
    }

    // endregion 新增&修改

    // region 构造方法

    /**
     * 私有无参构造
     */
    private UserOrganizationRela() {
    }

    /**
     * 仓储还原
     */
    public UserOrganizationRela(String id, String userId, String organizationId, String position, Boolean majorPositionFlag, Date recordTime) {
        this.id = id;
        this.userId = userId;
        this.organizationId = organizationId;
        this.position = position;
        this.majorPositionFlag = majorPositionFlag;
        this.recordTime = recordTime;
    }

    /**
     * 仓储还原
     */
    public UserOrganizationRela(String id, String userId, String organizationId, String position, Boolean majorPositionFlag, Date recordTime, String employeeNumber, String name) {
        this.id = id;
        this.userId = userId;
        this.organizationId = organizationId;
        this.position = position;
        this.majorPositionFlag = majorPositionFlag;
        this.recordTime = recordTime;
        this.employeeNumber = employeeNumber;
        this.name = name;
    }

    /**
     * 新增
     *
     * @param userId
     * @param organizationId
     * @param position
     * @param majorPositionFlag
     */
    public UserOrganizationRela(String userId, String organizationId, String position, Boolean majorPositionFlag) {
        this.id = SnowFlake.instant().nextId().toString();
        this.userId = userId;
        this.organizationId = organizationId;
        this.position = position;
        this.majorPositionFlag = majorPositionFlag;
        this.recordTime = new Date();
    }

    // endregion 构造方法

    // region 额外属性

    /**
     * 账号
     */
    private String username;
    /**
     * 用户名称
     */
    private String name;
    /**
     * 组织名称
     */
    private String organizationName;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    // endregion 额外属性

    // region 基础属性

    /**
     * 主键
     */
    private String id;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 组织ID
     */
    private String organizationId;
    /**
     * 用户岗位
     */
    private String position;
    /**
     * 是否为主岗
     */
    private Boolean majorPositionFlag;
    /**
     * 员工编号
     */
    private String employeeNumber;
    /**
     * 记录时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date recordTime;

    public String getId() {
        return id;
    }

    public String getUserId() {
        return userId;
    }

    public String getOrganizationId() {
        return organizationId;
    }

    public String getPosition() {
        return position;
    }

    public Boolean getMajorPositionFlag() {
        return majorPositionFlag;
    }

    public Date getRecordTime() {
        return recordTime;
    }

    public String getEmployeeNumber() {
        return employeeNumber;
    }

    // endregion 基础属性
}