package com.infoepoch.pms.dispatchassistant.domain.basic.user.organizationRela;

import java.util.List;

/**
 * 用户与组织关联表仓储接口
 */
public interface IUserOrganizationRelaRepository {
    /**
     * 新增
     *
     * @param: [entity]
     */
    boolean insert(UserOrganizationRela entity);

    /**
     * 更新
     *
     * @param: [entity]
     */
    boolean update(UserOrganizationRela entity);

    /**
     * 批量新增
     *
     * @param: [entitys]
     */
    int[] batchInsert(List<UserOrganizationRela> entitys);

    /**
     * 批量更新
     *
     * @param: [entitys]
     */
    int[] batchUpdate(List<UserOrganizationRela> entitys);

    /**
     * 删除
     *
     * @param: [id]
     */
    boolean delete(String id);

    /**
     * 根据用户ID列表删除记录
     *
     * @return
     */
    void deleteByUserIdList(List<String> userIdList);

    // region select

    /**
     * 根据Id查询
     *
     * @param: [id]
     */
    UserOrganizationRela selectById(String id);

    /**
     * 根据查询条件查询单个对象
     *
     * @param: [criteria]
     */
    UserOrganizationRela selectOneByCriteria(UserOrganizationRelaCriteria criteria);

    /**
     * 根据查询条件查询对象集合
     *
     * @param: [criteria]
     */
    List<UserOrganizationRela> selectByCriteria(UserOrganizationRelaCriteria criteria);

    /**
     * 根据查询条件分页查询对象结合
     *
     * @param: [criteria, pageIndex, pageSize]
     */
    List<UserOrganizationRela> selectCriteriaByPage(UserOrganizationRelaCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询对象总记录数
     *
     * @param: [criteria]
     */
    int selectCountByCriteria(UserOrganizationRelaCriteria criteria);

    /**
     * 根据员工编号查询
     * @param numberList
     * @return
     */
    List<UserOrganizationRela> selectByEmployeeNumberList(List<String> numberList);

    // endregion
}
