package com.infoepoch.pms.dispatchassistant.domain.basic.user;


import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;

import java.util.List;

/**
 * 用户查询条件
 */
public class UserCriteria extends AbstractCriteria {

    private List<String> organizationIds;   //组织id范围
    private List<Integer> types;            //类型范围
    private String keyword;                 //关键字，用户名或合中包含字符
    private Boolean disabled;               //状态
    private List<String> userIds;           //用户ID集合
    private String userName;                //用户名
    private String fullName;                //用户全名
    private String email;                   //邮箱
    private List<String> jobNumbers;               //工号
    private String organizationId; //组织id

    // 组织名称
    private String organizationName;

    // 工号查询（模糊）
    private String jobNumberContain;

    // 用户名列表
    private List<String> usernameList;

    // 角色名称
    private String roleName;
    // 是否开启地区筛选
    private Boolean regionFilterFlag;
    // 是否有领导
    private Boolean hasLeader;

    private Boolean branchCompanyFlag;

    private String branchCompanyId;

    private String departmentId;
    //部门简称
    private String shortName;

    public List<String> getOrganizationIds() {
        return organizationIds;
    }

    public List<Integer> getTypes() {
        return types;
    }

    public String getKeyword() {
        return keyword;
    }

    public Boolean isDisabled() {
        return disabled;
    }

    public List<String> getUserIds() {
        return userIds;
    }

    public String getUserName() {
        return userName;
    }

    public String getFullName() {
        return fullName;
    }

    public void setOrganizationIds(List<String> organizationIds) {
        this.organizationIds = organizationIds;
    }

    public void setTypes(List<Integer> types) {
        this.types = types;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setDisabled(Boolean disabled) { this.disabled = disabled; }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<String> getJobNumbers() {
        return jobNumbers;
    }

    public void setJobNumbers(List<String> jobNumbers) {
        this.jobNumbers = jobNumbers;
    }

    public String getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getJobNumberContain() {
        return jobNumberContain;
    }

    public void setJobNumberContain(String jobNumberContain) {
        this.jobNumberContain = jobNumberContain;
    }

    public List<String> getUsernameList() {
        return usernameList;
    }

    public void setUsernameList(List<String> usernameList) {
        this.usernameList = usernameList;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Boolean getRegionFilterFlag() {
        return regionFilterFlag != null && regionFilterFlag;
    }

    public void setRegionFilterFlag(Boolean regionFilterFlag) {
        this.regionFilterFlag = regionFilterFlag;
    }

    public Boolean getHasLeader() {
        return hasLeader;
    }

    public void setHasLeader(Boolean hasLeader) {
        this.hasLeader = hasLeader;
    }

    public Boolean getBranchCompanyFlag() {
        return branchCompanyFlag;
    }

    public void setBranchCompanyFlag(Boolean branchCompanyFlag) {
        this.branchCompanyFlag = branchCompanyFlag;
    }

    public String getBranchCompanyId() {
        return branchCompanyId;
    }

    public void setBranchCompanyId(String branchCompanyId) {
        this.branchCompanyId = branchCompanyId;
    }

    public String getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
}
