package com.infoepoch.pms.dispatchassistant.domain.basic.todo;

import com.infoepoch.pms.dispatchassistant.common.enums.EnumBase;

/**
 * 待办类型
 */
public enum TodoType implements EnumBase {

    TODO(0,"待办"),
    DONE(1, "已办"),
    TO_READ(2,"待阅"),
    READ(3,"已阅"),
    DRAFT(4,"草稿")
    ;

    private int value;
    private String text;

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getText() {
        return text;
    }

    TodoType(int value, String text) {
        this.value = value;
        this.text = text;
    }
}
