package com.infoepoch.pms.dispatchassistant.domain.basic.store;

import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class KeyValueStoreService {

    @Autowired
    private  IKeyValueStoreRepository keyValueStoreRepository;

//    public KeyValueStoreService(IKeyValueStoreRepository keyValueStoreRepository) {
//        this.keyValueStoreRepository = keyValueStoreRepository;
//    }

    /**
     * 查询键值对分页列表
     *
     * @param criteria
     * @return
     */
    public Map<String, Object> pageList(KeyValueStoreCriteria criteria) {
        Map<String, Object> resultMap = new HashMap<>();
        if(criteria.byPage()) {
            resultMap.put("list", keyValueStoreRepository.selectByCriteriaPage(criteria, criteria.getPageIndex(), criteria.getPageSize()));
        } else {
            resultMap.put("list", keyValueStoreRepository.selectByCriteria(criteria));
        }
        resultMap.put("totalCount", keyValueStoreRepository.selectByCriteriaCount(criteria));
        return resultMap;
    }

    /**
     * 新增键值对
     *
     * @param keyValueStore
     */
    public void addKeyValue(KeyValueStore keyValueStore) {
        keyValueStore.check();

        if (keyValueStoreRepository.judgeKeyRepeat(keyValueStore.getKey()))
            throw new ValidationException("键不可重复");

        keyValueStoreRepository.insert(keyValueStore);
    }

    /**
     * 修改值
     *
     * @param keyValueStore
     */
    public void modifyKeyValue(KeyValueStore keyValueStore) {
        keyValueStore.check();

        KeyValueStore old = keyValueStoreRepository.selectByKey(keyValueStore.getKey());
        if (old == null) {
            throw new ValidationException("键对应的记录不存在");
        }

        keyValueStoreRepository.update(keyValueStore);
    }

    /**
     *
     * @param key
     * @param value
     */
    public void save(String key, String value) {
        KeyValueStore keyValueStore = new KeyValueStore(key, value);
        if (keyValueStoreRepository.judgeKeyRepeat(keyValueStore.getKey())) {
            keyValueStoreRepository.update(keyValueStore);
        } else {
            keyValueStoreRepository.insert(keyValueStore);
        }
    }

    /**
     * 根据键查询值
     *
     * @param key
     * @return
     */
    public String queryValueByKey(String key) {
        return queryByKey(key).getValue();
    }

    /**
     * 根据键查询键值对实体
     *
     * @param key
     * @return
     */
    public KeyValueStore queryByKey(String key) {
        KeyValueStore keyValueStore = keyValueStoreRepository.selectByKey(key);
        if (keyValueStore == null)
            keyValueStore = new KeyValueStore();
        return keyValueStore;
    }

    /**
     * 修改值
     *
     * @param key   键
     * @param value 值
     */
    public void modifyValue(String key, String value) {
        KeyValueStore keyValueStore = new KeyValueStore(key, value);
        this.modifyKeyValue(keyValueStore);
    }

}
