package com.infoepoch.pms.dispatchassistant.domain.basic.role;



import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;

import java.util.Date;

/**
 * @author xuyj
 * @description 角色
 * @date 2019-11-11 10:08
 */
public class Role {

    /**
     * @return
     */
    public String getDisplayName() {
        return this.name;
    }

    private String id;
    /**
     * 角色名称
     */
    private String name;
    /**
     * 角色描述
     */
    private String description;

    /**
     * 是否禁用
     */
    private boolean disabled;

    /**
     * 是否可编辑、删除
     */
    private boolean editor;

    /**
     * 创建时间、修改时间
     */
    private Date createTime;
    private Date modifyTime;

    public Role() {
    }

    /**
     * 新增
     */
    public Role(String name, String description,boolean disabled) {
        this.id = String.valueOf(SnowFlake.instant().nextId());
        this.description = description;
        this.name = name;
        this.disabled = disabled;
        this.createTime = new Date();
        this.editor = true;
    }

    /**
     * 修改
     */
    public Role(String id, String name, String description, boolean disabled) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.disabled = disabled;
        this.modifyTime = new Date();
    }

    /**
     * 查询
     */
    public Role(String id, String name, String description, boolean disabled, boolean editor, Date createTime, Date modifyTime) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.disabled = disabled;
        this.editor = editor;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public boolean isDisabled() {
        return disabled;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public boolean isEditor() {
        return editor;
    }
}
