package com.infoepoch.pms.dispatchassistant.domain.basic.role;


import com.infoepoch.pms.dispatchassistant.domain.basic.user.User;

import java.util.List;

/**
 * @author xuyj
 * @description 用户角色关联表
 * @date 2019-11-14 10:57
 */
public interface IUserRoleRepository {
    /**
     * 批量关联用户角色
     *
     * @param roleId  角色id
     * @param userIds 菜单id集合
     */
    void batchInsert(String roleId, List<String> userIds);

    /**
     * 根据角色ID和组织ID列表删除关联用户记录
     *
     * @param roleId
     * @param orgIdList
     */
    void deleteByRoleIdAndOrgIdList(String roleId, List<String> orgIdList);

    /**
     * 删除所有角色关联的用户
     *
     * @param roleId
     */
    void deleteAll(String roleId);

    /**
     * 根据角色获取关联的用户
     *
     * @param roleId
     * @return
     */
    List<User> select(String roleId);

    /**
     * 根据角色/组织获取关联的用户
     *
     * @param roleId
     * @param orgId
     * @return
     */
    List<User> select(String roleId, String orgId);

    /**
     * 根据用户获取关联角色
     *
     * @param userId
     * @return
     */
    List<Role> selectRoleByUserId(String userId);


    /**
     * 查询未设置该角色的用户
     *
     * @param roleId
     * @return
     */
    List<User> selectNotSelectedUserByRoleId(String roleId, String parentOrgId);

    /**
     * 查询已设置该角色的用户
     *
     * @param roleId
     * @param userOrgId
     * @param parentOrgId
     * @return
     */
    List<User> selectSelectedUserByRoleId(String roleId, String parentOrgId);

    /**
     * 根据部门+名称查询未设置该角色的用户
     *
     * @param roleId
     * @param parentOrgId
     * @param fullName
     * @return
     */
    List<User> selectNotSelectedUserByRoleId(String roleId, String parentOrgId, String fullName);

    /**
     * 查询角色关联用户ID列表
     * @param roleId
     * @return
     */
    List<String> selectRelateUserIdList(String roleId);
}
