package com.infoepoch.pms.dispatchassistant.domain.basic.role;

import java.util.List;

/**
 * @author xuyj
 * @description 角色仓储
 * @date 2019-11-12 11:36
 */
public interface IRoleRepository {
    List<Role> selectByUserId(String userId);

    /**
     * 添加角色
     * @param role
     */
    void insert(Role role);

    /**
     * 修改角色
     * @param role
     */
    void update(Role role);

    /**
     * 删除角色
     * @param id
     */
    void delete(String id);

    /**
     * 分页查询
     * @param criteria
     * @return
     */
    List<Role> queryByPage(RoleCriteria criteria, int pageIndex, int pageSize);

    /**
     * 查询总数量
     * @param criteria
     * @return
     */
    int queryByPageCount(RoleCriteria criteria);

    /**
     * 根据角色名查询
     * @param roleName
     * @return
     */
    Role selectByRoleName(String roleName);

    /**
     *
     * @param roleId
     * @return
     */
    Role selectById(String roleId);

}
