package com.infoepoch.pms.dispatchassistant.domain.basic.organization;

import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;

import java.util.List;

public class OrganizationCriteria extends AbstractCriteria {

    /**
     * 组织ID列表
     */
    private List<String> orgIdList;

    public List<String> getOrgIdList() {
        return orgIdList;
    }

    public void setOrgIdList(List<String> orgIdList) {
        this.orgIdList = orgIdList;
    }

    // region 组织简称
    public boolean byShortName() {
        return this.andMap.containsKey("ShortName");
    }

    private String shortName;

    public String getShortName() {
        if (byShortName())
            return shortName;
        return null;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
        this.andMap.put("ShortName", shortName);
    }
    // endregion 组织简称

    // region 组织简称模糊查询

    public boolean byShortNameContain() {
        return this.andMap.containsKey("ShortNameContain");
    }

    private String shortNameContain;

    public String getShortNameContain() {
        if (byShortNameContain())
            return shortNameContain;
        return null;
    }

    public void setShortNameContain(String shortNameContain) {
        this.shortNameContain = shortNameContain;
        this.andMap.put("ShortNameContain", shortNameContain);
    }

    // endregion 组织简称模糊查询

    // region 组织名称

    private String nameContain;

    public String getNameContain() {
        return nameContain;
    }

    public void setNameContain(String nameContain) {
        this.nameContain = nameContain;
    }

    // endregion 组织名称

    // region 只查询到第三层组织

    private Boolean searchThreeFlag;

    public Boolean getSearchThreeFlag() {
        return searchThreeFlag != null && searchThreeFlag;
    }

    public void setSearchThreeFlag(Boolean searchThreeFlag) {
        this.searchThreeFlag = searchThreeFlag;
    }

    // endregion 只查询到第三层组织

    // region 是否禁用

    private Boolean disabledFlag;

    public Boolean getDisabledFlag() {
        return disabledFlag;
    }

    public void setDisabledFlag(Boolean disabledFlag) {
        this.disabledFlag = disabledFlag;
    }

    // endregion 是否禁用

    // region 树形父节点，查询之下所有

    private String treeParentId;

    public String getTreeParentId() {
        return treeParentId;
    }

    public void setTreeParentId(String treeParentId) {
        this.treeParentId = treeParentId;
    }

    // endregion 树形父节点，查询之下所有

    // region oa组织编码列表

    private List<String> oaOrgCodeList;

    public List<String> getOaOrgCodeList() {
        return oaOrgCodeList;
    }

    public void setOaOrgCodeList(List<String> oaOrgCodeList) {
        this.oaOrgCodeList = oaOrgCodeList;
    }

    // endregion oa组织编码列表

    // region 组织级别

    private Integer level;

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    // endregion 组织级别

    // region 组织级别列表

    private List<Integer> levelList;

    public List<Integer> getLevelList() {
        return levelList;
    }

    public void setLevelList(List<Integer> levelList) {
        this.levelList = levelList;
    }

    // endregion 组织级别列表

    // region 父组织ID列表

    private List<String> parentIdList;

    public List<String> getParentIdList() {
        return parentIdList;
    }

    public void setParentIdList(List<String> parentIdList) {
        this.parentIdList = parentIdList;
    }

    // endregion 父组织ID列表

    // region 组织名称列表

    private List<String> nameList;

    public List<String> getNameList() {
        return nameList;
    }

    public void setNameList(List<String> nameList) {
        this.nameList = nameList;
        this.andMap.put("NameList", nameList);
    }

    // endregion 组织名称列表

}
