package com.infoepoch.pms.dispatchassistant.domain.basic.organization;

import java.util.List;
import java.util.Map;

/**
 * @Description 组织机构仓储
 * @Author lxd
 **/
public interface IOrganizationRepository {

    /**
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<Organization> selectByCriteriaPage(OrganizationCriteria criteria, int pageIndex, int pageSize);

    /**
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<Organization> selectByCriteriaPage(OrganizationCriteria criteria, int pageIndex, int pageSize, String orderBy, boolean isDesc);

    /**
     * @param criteria
     * @return
     */
    int selectCountByCriteria(OrganizationCriteria criteria);

    /**
     * @param criteria
     * @return
     */
    List<Organization> selectByCriteria(OrganizationCriteria criteria);

    /**
     * @Description: 根据父id查询
     * @Param: [parentId]
     * @Author: zhangyd
     */
    List<Organization> selectByParentId(String parentId);

    /**
     * 根据父id列表查询
     *
     * @param parentIdList
     * @return
     */
    List<Organization> selectByParentIdList(List<String> parentIdList);

    /**
     * @Description: 获取所有组织Map
     * @Param: []
     * @Author: zhangyd
     */
    Map<String, Organization> selectMapAll();

    /**
     * @return
     */
    List<Organization> selectAll();

    /**
     * @param id
     * @return
     */
    Organization selectById(String id);

    /**
     * @param ids
     * @return
     */
    List<Organization> selectByIds(List<String> ids);

    /**
     * @param name
     * @return
     */
    Organization selectByName(String name);

    /**
     * @param shortName
     * @return
     */
    Organization selectByShortName(String shortName);

    /**
     * @param organization
     */
    void insert(Organization organization);

    /**
     * 批量插入组织机构信息
     *
     * @param organizationList
     */
    void batchInsert(List<Organization> organizationList);

    /**
     * @param organization
     */
    void update(Organization organization);

    /**
     * 批量更新组织机构信息
     *
     * @param organizationList
     */
    void batchUpdate(List<Organization> organizationList);

    /**
     * 批量更新层级
     *
     * @param organizationList
     */
    void batchUpdateLevel(List<Organization> organizationList);

    /**
     * 根据ID删除
     *
     * @param id
     */
    void deleteById(String id);

    /**
     * 根据oaOrgCode查询组织
     *
     * @param oaOrgCode
     * @return
     */
    Organization selectByOaOrgCode(String oaOrgCode);

}
