package com.infoepoch.pms.dispatchassistant.domain.basic.menu;

import java.util.List;

/**
 * @author xuyj
 * @description 菜单仓储
 * @date 2019-11-11 15:35
 */
public interface IMenuRepository {

    /**
     * 添加菜单
     *
     * @param menu
     */
    void insert(Menu menu);

    /**
     * 根据id删除菜单
     *
     * @param id
     */
    void deleteMenuById(String id);

    /**
     * 根据id修改菜单
     *
     * @param menu
     */
    void updateMenuById(Menu menu);

    /**
     * 根据用户id查询不同类型菜单（区分合作单位和移动员工）
     *
     * @param userId
     * @return
     */
    List<Menu> selectMainMenuByUserId(String userId);

    /**
     * 删除菜单，根据角色id（删除角色时同时删除）
     *
     * @param roleId
     */
    void deleteByRoleId(String roleId);

    /**
     * 查询菜单（菜单管理）
     *
     * @param type
     * @return
     */
    List<Menu> selectAll(int type);

    /**
     * 根据url查询menu
     *
     * @param url
     * @return
     */
    Menu selectByUrl(String url);

    /**
     * 根据角色名查询菜单
     *
     * @param roleName
     * @return
     */
    List<Menu> selectMainMenuByRoleName(String roleName);

    /**
     * 根据名称查询菜单
     */
    List<Menu> selectByName(String name);

    /**
     * 根据菜单名称集合查询菜单
     */
    List<Menu> selectByNameList(List<String> nameList);

    /**
     * 根据供应商/供应商员工id查询菜单
     *
     * @param saId
     * @return
     */
    List<Menu> selectMainMenuBySaId(String saId);

    /**
     * 根据供应商/供应商员工 角色名称查询菜单
     *
     * @param roleName
     * @return
     */
    List<Menu> selectMainMenuBySaRoleName(String roleName);

    /**
     * 根据id 查询菜单
     * @param id
     * @return
     */
    Menu selectById(String id);
}
