package com.infoepoch.pms.dispatchassistant.controller.system;

import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.common.exception.NotLoginException;
import com.infoepoch.pms.dispatchassistant.controller.basic.Auth;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.DictDataService;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.SystemDictCriteria;
import com.infoepoch.pms.dispatchassistant.domain.system.dict.SystemDictData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/dict-data")
public class DictDataController {

    @Autowired
    private Auth auth;
    @Autowired
    private DictDataService dictDataService;

    /**
     * 列表
     *
     * @param criteria
     * @return
     */
    @PostMapping("/list")
    public Result list(@RequestBody SystemDictCriteria criteria) {
        return Result.successData(dictDataService.pageList(criteria));
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public Result detail(@PathVariable("id") String id) {
        return Result.successData(dictDataService.detailById(id));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @GetMapping("/remove/{id}")
    public Result remove(@PathVariable("id") String id) {
        dictDataService.removeById(id);
        return Result.success();
    }

    /**
     * 保存
     *
     * @param dictData
     * @return
     * @throws NotLoginException
     */
    @PostMapping("/save")
    public Result save(@RequestBody SystemDictData dictData) throws NotLoginException {
        dictDataService.save(dictData);
        return Result.success();
    }

    /**
     * 获取字典值列表
     *
     * @param dictType
     * @return
     */
    @GetMapping("/get/{dictType}")
    public Result getDictTypeData(@PathVariable("dictType") String dictType) {
        return Result.successData(dictDataService.queryByDictType(dictType));
    }

    /**
     * 获取字典值列表
     *
     * @param dictType
     * @return
     */
    @GetMapping("/get-map/{dictType}")
    public Result getDictTypeMap(@PathVariable("dictType") String dictType) {
        return Result.successData(dictDataService.queryMapByDictType(dictType));
    }

    /**
     * 获取全量字典值列表
     *
     * @param dictType
     * @return
     */
    @GetMapping("/get-all/{dictType}")
    public Result getAllDictTypeData(@PathVariable("dictType") String dictType) {
        return Result.successData(dictDataService.queryByDictType(dictType, true));
    }

    /**
     * 批量保存
     *
     * @param dictDataList
     * @return
     * @throws NotLoginException
     */
    @PostMapping("/batch-save")
    public Result saveAll(@RequestBody List<SystemDictData> dictDataList) throws NotLoginException {
        dictDataService.batchSave(dictDataList);
        return Result.success();
    }

}
