package com.infoepoch.pms.dispatchassistant.controller.expertOpenApI;

import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import com.infoepoch.pms.dispatchassistant.common.utils.StringUtils;
import com.infoepoch.pms.dispatchassistant.domain.expertInformation.ExpertInformation;
import com.infoepoch.pms.dispatchassistant.domain.expertInformation.ExpertInformationCriteria;
import com.infoepoch.pms.dispatchassistant.domain.expertInformation.ExpertInformationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/expertApi")
public class expertController {

    @Autowired
    private ExpertInformationService service;


    /**
     * 根据条件查询列表
     **/
    @PostMapping("selectExpertInformation")
    public Result selectExpertInformation(@RequestBody ExpertInformationCriteria criteria) {
        criteria.removeMapNullOrEmpty();
        Map<String, Object> map = service.selectExpertInformation(criteria);
        return Result.successData(map);
    }

    /**
     * 根据条件查询列表
     **/
    @PostMapping("selectExternalExpertInformation")
    public Result selectExternalExpertInformation(@RequestBody ExpertInformationCriteria criteria) {
        criteria.removeMapNullOrEmpty();
        Map<String, Object> map = service.selectExternalExpertInformation(criteria);
        return Result.successData(map);
    }





}
