package com.infoepoch.pms.dispatchassistant.controller.basic;

import com.infoepoch.pms.dispatchassistant.common.component.Result;
import com.infoepoch.pms.dispatchassistant.common.constant.StoreKeys;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStore;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStoreCriteria;
import com.infoepoch.pms.dispatchassistant.domain.basic.store.KeyValueStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 键值对仓库控制层
 */
@RestController
@RequestMapping("/api/key-value-store")
public class KeyValueStoreController {

    @Autowired
    private KeyValueStoreService keyValueStoreService;

    /**
     * 键值对列表
     *
     * @param criteria
     * @return
     */
    @PostMapping("/list")
    public Result pageList(@RequestBody KeyValueStoreCriteria criteria) {
        return Result.successData(keyValueStoreService.pageList(criteria));
    }

    /**
     * 新增键值对
     *
     * @param keyValueStore
     * @return
     */
    @PostMapping("/add")
    public Result add(@RequestBody KeyValueStore keyValueStore) {
        keyValueStoreService.addKeyValue(keyValueStore);
        return Result.success();
    }

    /**
     * 修改值
     *
     * @param keyValueStore
     * @return
     */
    @PostMapping("/modify")
    public Result modify(@RequestBody KeyValueStore keyValueStore) {
        keyValueStoreService.modifyKeyValue(keyValueStore);
        return Result.success();
    }

    /**
     * 平台名称
     * @return
     */
    @GetMapping("/platform-name")
    public Result platformName() {
        return Result.successData(keyValueStoreService.queryValueByKey(StoreKeys.PLATFORM_NAME));
    }

}
