package com.infoepoch.pms.dispatchassistant.common.utils;

import com.infoepoch.pms.dispatchassistant.domain.oa.SSOResponse;
import com.thoughtworks.xstream.XStream;
import org.apache.commons.io.IOUtils;

import java.io.InputStream;

/**
 * @author 王伟
 * 
 * 该类可以从输入流里解析XML串，并返回一个bean对象
 * 
 */
public class XMLProxy {

    private static XMLProxy instance = null;

    private XStream responseXStream;

    public static XMLProxy getInstance() {
        if (instance == null)
            instance = new XMLProxy();
        return instance;
    }

    private XMLProxy() {
        responseXStream = new XStream();
        responseXStream.setClassLoader(SSOResponse.class.getClassLoader());
        responseXStream.alias("response", SSOResponse.class);
    }

    public Object fromResponseXML(InputStream is) {
        return responseXStream.fromXML(is);
    }


    public static void main(String[] args) {
    	String str="<response>\n" +
                "  <status>ok</status>\n" +
                "  <uid>mayq</uid>\n" +
                "</response>";

    	InputStream is = IOUtils.toInputStream(str);
        SSOResponse respXML = (SSOResponse)XMLProxy.getInstance().fromResponseXML(is);
//    	System.out.println(respXML.getEmployeeNumber());
    	return;
	}
}
