package com.infoepoch.pms.dispatchassistant.common.utils;

public class UrlTool {

    public final static String SEPARATOR = "/";

    public static String splicingUrls(String... urls) {
        String result = "";
        for (String url : urls) {
            result = splicingUrl(result, url);
        }
        return result;
    }

    /**
     * 拼接URL
     *
     * @param prefix
     * @param suffix
     * @return
     */
    public static String splicingUrl(String prefix, String suffix) {
        if (StringUtils.isBlank(prefix)) {
            if (StringUtils.isNotBlank(suffix) && !suffix.startsWith(SEPARATOR))
                return SEPARATOR + suffix;
        } else {
            if (!prefix.startsWith(SEPARATOR) && !prefix.startsWith("http"))
                prefix = SEPARATOR + prefix;
            if (prefix.endsWith(SEPARATOR))
                prefix = prefix.substring(0, prefix.length() - 1);
            if (StringUtils.isBlank(suffix))
                suffix = SEPARATOR;
            if (!suffix.startsWith(SEPARATOR))
                suffix = SEPARATOR + suffix;
            return prefix + suffix;
        }
        return SEPARATOR;
    }

    /**
     * 带有检查的拼接URL
     *
     * @param prefix
     * @param suffix
     * @return
     */
    public static String splicingUrlWithCheck(String prefix, String suffix) {
        if (StringUtils.isNotBlank(prefix) && StringUtils.isNotBlank(suffix) && (suffix.startsWith(prefix) || suffix.startsWith(SEPARATOR + prefix)))
            return suffix;
        else
            return splicingUrl(prefix, suffix);
    }

}
