package com.infoepoch.pms.dispatchassistant.common.tuple;

/**
 * 元组，包含2个元素
 *
 * @param <A>
 * @param <B>
 */
public class TupleTwo<A, B> {

    private final A first;      //元组中第1个元素
    private final B second;     //元组中第2个元素

    public TupleTwo() {
        this.first = null;
        this.second = null;
    }

    /**
     * 构造函数
     */
    public TupleTwo(A a, B b) {
        this.first = a;
        this.second = b;
    }

    /**
     * 取元组中第1个元素
     */
    public A getFirst() {
        return this.first;
    }

    /**
     * 取元组中第2个元素
     */
    public B getSecond() {
        return this.second;
    }
}
