/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.failover.Listener;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceAddressList;
import com.oceanbase.jdbc.internal.failover.tools.SearchFilter;
import com.oceanbase.jdbc.internal.failover.utils.HostStateInfo;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public interface BalanceStrategy {
    public static boolean allBlack(List<HostAddress> loopAddress, ConcurrentMap<HostAddress, HostStateInfo> blacklist) {
        if (blacklist.keySet().size() == 0) {
            return false;
        }
        if (!blacklist.keySet().containsAll(loopAddress)) {
            return false;
        }
        for (HostAddress hostAddress : blacklist.keySet()) {
            if (!loopAddress.contains(hostAddress) || ((HostStateInfo)blacklist.get(hostAddress)).getState() == HostStateInfo.STATE.BLACK) continue;
            return false;
        }
        return true;
    }

    public void pickConnection(LoadBalanceAddressList var1, UrlParser var2, Listener var3, GlobalStateInfo var4, SearchFilter var5, ConcurrentMap<HostAddress, HostStateInfo> var6, Set<HostAddress> var7) throws SQLException;

    public void pickConnectionFallThrough(LoadBalanceAddressList var1, Listener var2, GlobalStateInfo var3) throws SQLException;
}

