/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.OBArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStructParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class ComStmtExecute {
    public static void send(PacketOutputStream pos, int statementId, ParameterHolder[] parameters, int parameterCount, ColumnType[] parameterTypeHeader, byte cursorFlag, Protocol protocol) throws IOException, SQLException {
        pos.startPacket(0);
        pos.write(23);
        pos.writeInt(statementId);
        pos.write(cursorFlag);
        if (protocol.versionGreaterOrEqual(4, 1, 2)) {
            if (protocol.isOracleMode() && protocol.getOptions().useServerPsStmtChecksum) {
                pos.writeInt((int)protocol.getChecksum());
            } else {
                pos.writeInt(1);
            }
        } else {
            pos.writeInt(1);
        }
        if (parameterCount > 0) {
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                if (!parameters[i2].isNullData()) continue;
                int n = i2 / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
            }
            pos.write(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = false;
            if (parameterTypeHeader != null && parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i = 0; i < parameterCount; ++i) {
                    if (parameterTypeHeader[i].equals((Object)parameters[i].getColumnType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            if (mustSendHeaderType) {
                pos.write(1);
                for (i = 0; i < parameterCount; ++i) {
                    parameterTypeHeader[i] = parameters[i].getColumnType();
                    pos.writeShort(parameterTypeHeader[i].getType());
                    if (parameterTypeHeader[i].getType() != ColumnType.COMPLEX.getType()) continue;
                    ParameterHolder obj = parameters[i];
                    if (obj instanceof OBArrayParameter) {
                        ((OBArrayParameter)obj).storeArrayTypeInfo(pos);
                        continue;
                    }
                    if (obj instanceof OBStructParameter) {
                        ((OBStructParameter)obj).storeStructTypeInfo(pos);
                        continue;
                    }
                    throw new SQLException("complex param type is not supported\uff0c only array is supported");
                }
            } else {
                pos.write(0);
            }
        }
        for (int i = 0; i < parameterCount; ++i) {
            ParameterHolder holder = parameters[i];
            if (holder.isNullData() || holder.isLongData()) continue;
            holder.writeBinary(pos);
        }
        pos.flush();
    }

    public static void writeCmdArrayBinding(int statementId, List<ParameterHolder[]> queryParameters, int queryParamtersSize, int parameterCount, ColumnType[] parameterTypeHeader, PacketOutputStream pos, byte cursorFlag, Protocol protocol) throws IOException, SQLException {
        pos.write(23);
        pos.writeInt(statementId);
        pos.write(cursorFlag | 8);
        if (protocol.versionGreaterOrEqual(4, 1, 2)) {
            if (protocol.isOracleMode() && protocol.getOptions().useServerPsStmtChecksum) {
                pos.writeInt((int)protocol.getChecksum());
            } else {
                pos.writeInt(1);
            }
        } else {
            pos.writeInt(1);
        }
        if (parameterCount > 0) {
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            pos.write(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = true;
            if (mustSendHeaderType) {
                pos.write(1);
                for (int i = 0; i < parameterCount; ++i) {
                    pos.writeShort(ColumnType.COMPLEX.getType());
                    pos.writeFieldLength(0L);
                    pos.writeFieldLength(0L);
                    pos.writeFieldLength(0L);
                    short elementType = queryParameters.get(0)[i].getColumnType().getType();
                    pos.writeBytes((byte)elementType, 1);
                }
            } else {
                pos.write(0);
            }
        }
        for (int i = 0; i < parameterCount; ++i) {
            pos.writeFieldLength(queryParamtersSize);
            int nullCount = (queryParamtersSize + 7) / 8;
            int nullBitsPosition = pos.getPosition();
            for (int j = 0; j < nullCount; ++j) {
                pos.writeBytes((byte)0, 1);
            }
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int j = 0; j < queryParamtersSize; ++j) {
                ParameterHolder holder = queryParameters.get(j)[i];
                if (null != holder) {
                    holder.writeBinary(pos);
                    continue;
                }
                int n = j / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << j % 8);
            }
            int endPosition = pos.getPosition();
            pos.setPosition(nullBitsPosition);
            pos.write(nullBitsBuffer);
            pos.setPosition(endPosition);
        }
    }

    public static void sendArrayBinding(PacketOutputStream pos, int statementId, List<ParameterHolder[]> queryParameters, int queryParamtersSize, int parameterCount, ColumnType[] parameterTypeHeader, byte cursorFlag, Protocol protocol) throws IOException, SQLException {
        pos.startPacket(0);
        ComStmtExecute.writeCmdArrayBinding(statementId, queryParameters, queryParamtersSize, parameterCount, parameterTypeHeader, pos, cursorFlag, protocol);
        pos.flush();
    }
}

