/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.extend.datatype.Datum;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TIMESTAMPLTZ
extends Datum {
    private static int SIZE_TIMESTAMPLTZ = 12;
    private static int SIZE_TIMESTAMPLTZ_NOFRAC = 7;
    private static int SIZE_DATE = 7;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int JAVA_YEAR = 1970;
    private static int JAVA_MONTH = 0;
    private static int JAVA_DATE = 1;
    private static int MINYEAR = -4712;
    private static int MAXYEAR = 9999;
    private static boolean cached = false;
    private static Calendar dbtz;

    public TIMESTAMPLTZ() {
        super(TIMESTAMPLTZ.initTimestampltz());
    }

    public TIMESTAMPLTZ(byte[] bytes) {
        super(bytes);
    }

    public TIMESTAMPLTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, time));
    }

    public TIMESTAMPLTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, date));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, timestamp));
    }

    public static String toString(Connection connection, byte[] bytes, boolean isResult) throws SQLException {
        if (bytes.length < 12) {
            throw new SQLException("invalid bytes length");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone()));
        calendar.setTimeInMillis(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone())));
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int nanos = TIMESTAMP.getNanos(bytes, 7);
        return TIMESTAMPLTZ.toString(year, month, day, hour, minute, second, nanos, bytes[11], TIMESTAMPLTZ.getSessionTimeZone(connection), isResult);
    }

    private static final String toStr(int temp) {
        return temp < 10 ? "0" + temp : Integer.toString(temp);
    }

    public static final String toString(int year, int month, int day, int hour, int minute, int second, int nanos, int scale, String timezone, boolean isResult) {
        String time = "" + year + "-" + TIMESTAMPLTZ.toStr(month) + "-" + TIMESTAMPLTZ.toStr(day) + " " + TIMESTAMPLTZ.toStr(hour) + ":" + TIMESTAMPLTZ.toStr(minute) + ":" + TIMESTAMPLTZ.toStr(second);
        int target = 0;
        target = isResult ? 0 : 1;
        if (nanos >= target) {
            int index;
            String temp = String.format("%09d", nanos);
            char[] chars = temp.toCharArray();
            for (index = chars.length; index > 1 && chars[index - 1] == '0'; --index) {
            }
            temp = temp.substring(0, index);
            time = time + "." + temp;
        }
        if (timezone != null) {
            time = time + " " + timezone;
        }
        return time;
    }

    public String toResultSetString(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes(), true);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, Time time) throws SQLException {
        if (time == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int base = 1970;
        calendar.set(1, base);
        calendar.set(2, 0);
        calendar.set(5, 1);
        byte[] bytes = TIMESTAMPLTZ.toBytes(connection, calendar, 0);
        return bytes;
    }

    public static byte[] toBytes(Connection connection, Date date) throws SQLException {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        byte[] result = TIMESTAMPLTZ.toBytes(connection, calendar, 0);
        return result;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int nanos = timestamp.getNanos();
        byte[] bytes = TIMESTAMPLTZ.toBytes(connection, calendar, nanos);
        return bytes;
    }

    public static byte[] toBytes(Connection connection, String time) throws SQLException {
        return TIMESTAMPLTZ.toBytes(connection, Timestamp.valueOf(time));
    }

    @Override
    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public static Date toDate(Connection connection, byte[] bytes) throws SQLException {
        return new Date(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone()), false));
    }

    public static Time toTime(Connection connection, byte[] bytes) throws SQLException {
        return new Time(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone())));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] bytes) throws SQLException {
        if (bytes.length < 12) {
            throw new SQLException("invalid bytes length");
        }
        Timestamp timestamp = new Timestamp(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(((OceanBaseConnection)connection).getSessionTimeZone())));
        timestamp.setNanos(TIMESTAMP.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes) throws SQLException {
        if (bytes.length < 12) {
            throw new SQLException("invalid bytes length");
        }
        Timestamp timestamp = new Timestamp(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(protocol.getTimeZone().getID()), false));
        timestamp.setNanos(TIMESTAMP.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(Protocol protocol, byte[] bytes, boolean isResult) throws SQLException {
        if (bytes.length < 12) {
            throw new SQLException("invalid bytes length");
        }
        Timestamp timestamp = new Timestamp(TIMESTAMPTZ.getOriginTime(bytes, TimeZone.getTimeZone(protocol.getTimeZone().getID()), !isResult));
        timestamp.setNanos(TIMESTAMP.getNanos(bytes, 7));
        return timestamp;
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(connection, bytes));
    }

    public static TIMESTAMP toTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(protocol, bytes));
    }

    public static TIMESTAMP resultTIMESTAMP(Protocol protocol, byte[] bytes) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(protocol, bytes, true));
    }

    public static TIMESTAMPTZ toTIMESTAMPTZ(Connection connection, byte[] bytes) throws SQLException {
        return new TIMESTAMPTZ(connection, TIMESTAMPLTZ.toTimestamp(connection, bytes), Calendar.getInstance());
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, this.getBytes());
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes(), false);
    }

    public Date dateValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes());
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes());
    }

    @Override
    public Object toJdbc() throws SQLException {
        return null;
    }

    @Override
    public Object makeJdbcArray(int time) {
        Timestamp[] timestamps = new Timestamp[time];
        return timestamps;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    private static byte[] initTimestampltz() {
        byte[] result = new byte[SIZE_TIMESTAMPLTZ];
        result[0] = 19;
        result[1] = 70;
        result[2] = 1;
        result[3] = 1;
        result[4] = 1;
        result[5] = 1;
        result[6] = 1;
        TIMESTAMP.setNanos(result, 7, 0);
        result[11] = 0;
        return result;
    }

    private static byte[] toBytes(Connection connection, Calendar calendar, int nanos) throws SQLException {
        byte[] result = new byte[SIZE_TIMESTAMPLTZ];
        int year = calendar.get(1);
        if (year >= MINYEAR && year <= MAXYEAR) {
            int index;
            result[0] = (byte)(calendar.get(1) / 100);
            result[1] = (byte)(calendar.get(1) % 100);
            result[2] = (byte)(calendar.get(2) + 1);
            result[3] = (byte)calendar.get(5);
            result[4] = (byte)calendar.get(11);
            result[5] = (byte)calendar.get(12);
            result[6] = (byte)calendar.get(13);
            TIMESTAMP.setNanos(result, 7, nanos);
            String temp = String.format("%09d", nanos);
            char[] chars = temp.toCharArray();
            for (index = chars.length; index > 1 && chars[index - 1] == '0'; --index) {
            }
            temp = temp.substring(0, index);
            String nanosStr = String.valueOf(temp);
            result[11] = (byte)nanosStr.length();
            return result;
        }
        throw new SQLException("error format", "268");
    }
}

