/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BINARY_FLOAT
extends Datum {
    public static final boolean TRACE = false;

    public BINARY_FLOAT() {
    }

    public BINARY_FLOAT(byte[] bytes) {
        super(bytes);
    }

    public BINARY_FLOAT(float floatVal) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(floatVal));
    }

    public BINARY_FLOAT(Float floatVal) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(floatVal.floatValue()));
    }

    public BINARY_FLOAT(String stringVal) throws SQLException {
        this(BINARY_FLOAT.stringToFloat(stringVal));
    }

    public BINARY_FLOAT(Boolean booleanVal) {
        this(booleanVal != false ? 1 : 0);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return new Float(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
    }

    @Override
    public boolean isConvertibleTo(Class targetClass) {
        String className = targetClass.getName();
        return className.compareTo("java.lang.String") == 0 || className.compareTo("java.lang.Float") == 0;
    }

    @Override
    public String stringValue() {
        return Float.toString(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
    }

    @Override
    public float floatValue() throws SQLException {
        return BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes());
    }

    @Override
    public double doubleValue() throws SQLException {
        return this.floatValue();
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(this.floatValue());
    }

    private static float stringToFloat(String stringVal) throws SQLException {
        return Float.valueOf(stringVal).floatValue();
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        return new Float[intVal];
    }

    static byte[] floatToCanonicalFormatBytes(float floatVal) {
        int floatPos4;
        float floatValTmp = floatVal;
        if (floatVal == 0.0f) {
            floatValTmp = 0.0f;
        } else if (floatVal != floatVal) {
            floatValTmp = Float.NaN;
        }
        int floatToIntBits = Float.floatToIntBits(floatValTmp);
        byte[] bytes = new byte[4];
        int floatPos1 = floatToIntBits;
        int floatPos2 = floatToIntBits >>= 8;
        int floatPos3 = floatToIntBits >>= 8;
        if (((floatToIntBits >>= 8) & 0x80) == 0) {
            floatPos4 = floatToIntBits | 0x80;
        } else {
            floatPos4 = ~floatToIntBits;
            floatPos3 ^= 0xFFFFFFFF;
            floatPos2 ^= 0xFFFFFFFF;
            floatPos1 ^= 0xFFFFFFFF;
        }
        bytes[3] = (byte)floatPos1;
        bytes[2] = (byte)floatPos2;
        bytes[1] = (byte)floatPos3;
        bytes[0] = (byte)floatPos4;
        return bytes;
    }

    static float canonicalFormatBytesToFloat(byte[] bytes) {
        int aInt4;
        int aInt3;
        int aInt2;
        int aInt1;
        if ((bytes[0] & 0x80) != 0) {
            aInt1 = bytes[0] & 0x7F;
            aInt2 = bytes[1] & 0xFF;
            aInt3 = bytes[2] & 0xFF;
            aInt4 = bytes[3] & 0xFF;
        } else {
            aInt1 = ~bytes[0] & 0xFF;
            aInt2 = ~bytes[1] & 0xFF;
            aInt3 = ~bytes[2] & 0xFF;
            aInt4 = ~bytes[3] & 0xFF;
        }
        int intVal = aInt1 << 24 | aInt2 << 16 | aInt3 << 8 | aInt4;
        return Float.intBitsToFloat(intVal);
    }
}

