/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.Blob;
import com.oceanbase.jdbc.ClientSidePreparedStatement;
import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.ConnectionImpl;
import com.oceanbase.jdbc.JDBC4NClob;
import com.oceanbase.jdbc.OceanBaseDatabaseMetaData;
import com.oceanbase.jdbc.OceanBaseFunctionStatement;
import com.oceanbase.jdbc.OceanBasePooledConnection;
import com.oceanbase.jdbc.OceanBaseProcedureStatement;
import com.oceanbase.jdbc.OceanBaseSavepoint;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.jdbc.ServerSidePreparedStatement;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.extend.datatype.ArrayImpl;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.StructImpl;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.CallableStatementCache;
import com.oceanbase.jdbc.internal.util.LRUCache;
import com.oceanbase.jdbc.internal.util.StringCacheUtil;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.CallableStatementCacheKey;
import com.oceanbase.jdbc.internal.util.dao.CloneableCallableStatement;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import com.oceanbase.jdbc.internal.util.pool.Pools;
import com.oceanbase.jdbc.util.Options;
import java.net.SocketException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLPermission;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OceanBaseConnection
implements ConnectionImpl {
    private static final Logger logger = LoggerFactory.getLogger(OceanBaseConnection.class);
    public static final Pattern CALLABLE_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\{)?\\s*((\\?\\s*=)?(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*call(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*((((`[^`]+`)|([^`\\}]+))\\.)?((`[^`]+`)|([^`\\}\\(]+)))\\s*(\\(.*\\))?(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(#.*)?)\\s*(\\}\\s*)?$", 34);
    private static final Pattern PREPARABLE_STATEMENT_PATTERN_ORACLE = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|CALL|DECLARE|SHOW)", 2);
    private static final Pattern PREPARABLE_STATEMENT_PATTERN_MYSQL = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|DECLARE|SHOW)", 2);
    public final ReentrantLock lock;
    private final Protocol protocol;
    private final Options options;
    public OceanBasePooledConnection pooledConnection;
    protected boolean nullCatalogMeansCurrent;
    private CallableStatementCache callableStatementCache;
    private volatile int lowercaseTableNames = -1;
    private boolean canUseServerTimeout;
    private boolean sessionStateAware;
    private int stateFlag = 0;
    private int defaultTransactionIsolation = 0;
    private ExceptionFactory exceptionFactory;
    private boolean warningsCleared;
    private LRUCache serverSideStatementCheckCache;
    private LRUCache serverSideStatementCache;
    private LRUCache complexDataCache;
    private UrlParser urlParser;
    private GlobalStateInfo globalStateInfo;
    private TimeZone sessionTimeZone = TimeZone.getDefault();
    private static final int DEPTH_INDEX = 1;
    private static final int PARENT_TYPE_INDEX = 3;
    private static final int CHILD_TYPE_INDEX = 4;
    private static final int ATTR_NO_INDEX = 5;
    private static final int CHILD_OWNER_INDEX = 6;
    private static final int ATTR_TYPE_INDEX = 7;
    private String origHostToConnectTo;
    private boolean isInGlobalTx = false;
    private boolean enableNetworkStatistics = false;
    private int origPortToConnectTo;
    private String origDatabaseToConnectTo;
    private Connection complexConnection = null;
    private boolean autoCommit = true;
    private Map<String, Class<?>> typeMap;
    private static final String complexTypeSql = "SELECT\n  0 DEPTH,\n  NULL PARENT_OWNER,\n  NULL PARENT_TYPE,\n  to_char(TYPE_NAME) CHILD_TYPE,\n  0 ATTR_NO,\n  SYS_CONTEXT('USERENV', 'CURRENT_USER') CHILD_TYPE_OWNER,\n  A.TYPECODE ATTR_TYPE_CODE,\n  NULL LENGTH,\n  NULL NUMBER_PRECISION,\n  NULL SCALE,\n  NULL CHARACTER_SET_NAME\nFROM\n  USER_TYPES A WHERE TYPE_NAME = ?\nUNION\n(\nWITH \nCTE_RESULT(PARENT_OWNER, PARENT_TYPE, CHILD_TYPE, ATTR_NO, CHILD_TYPE_OWNER, ATTR_TYPE_CODE, LENGTH, NUMBER_PRECISION, SCALE, CHARACTER_SET_NAME) \nAS (\n    SELECT\n      SYS_CONTEXT('USERENV','CURRENT_USER') PARENT_OWNER,\n      B.TYPE_NAME PARENT_TYPE,\n      B.ELEM_TYPE_NAME CHILD_TYPE,\n      0 ATTR_NO,\n      B.ELEM_TYPE_OWNER CHILD_TYPE_OWNER,\n      NVL(A.TYPECODE, B.ELEM_TYPE_NAME) AS ATTR_TYPE_CODE,\n      B.LENGTH LENGTH,\n      B.NUMBER_PRECISION NUMBER_PRECISION,\n      B.SCALE SCALE,\n      B.CHARACTER_SET_NAME CHARACTER_SET_NAME\n    FROM\n      USER_COLL_TYPES B LEFT JOIN USER_TYPES A ON A.TYPE_NAME = B.ELEM_TYPE_NAME\n    UNION\n    SELECT\n      SYS_CONTEXT('USERENV','CURRENT_USER') PARENT_OWNER,\n      B.TYPE_NAME PARENT_TYPE,\n      B.ATTR_TYPE_NAME CHILD_TYPE,\n      B.ATTR_NO ATTR_NO,\n      B.ATTR_TYPE_OWNER CHILD_TYPE_OWNER,\n      NVL(A.TYPECODE, B.ATTR_TYPE_NAME) AS ATTR_TYPE_CODE,\n      B.LENGTH LENGTH,\n      B.NUMBER_PRECISION NUMBER_PRECISION,\n      B.SCALE SCALE,\n      B.CHARACTER_SET_NAME CHARACTER_SET_NAME\n    FROM USER_TYPE_ATTRS B LEFT JOIN USER_TYPES A ON B.ATTR_TYPE_NAME = A.TYPE_NAME ORDER BY ATTR_NO\n) ,\nCTE(DEPTH, PARENT_OWNER, PARENT_TYPE, CHILD_TYPE, ATTR_NO, CHILD_TYPE_OWNER, ATTR_TYPE_CODE, LENGTH, NUMBER_PRECISION, SCALE, CHARACTER_SET_NAME)\nAS (\n  SELECT\n    1 DEPTH,\n    PARENT_OWNER,\n    PARENT_TYPE,\n    CHILD_TYPE,\n    ATTR_NO,\n    CHILD_TYPE_OWNER,\n    ATTR_TYPE_CODE,\n    LENGTH,\n    NUMBER_PRECISION,\n    SCALE, CHARACTER_SET_NAME\n  FROM CTE_RESULT WHERE PARENT_TYPE = ?\n  UNION ALL\n  SELECT\n    DEPTH + 1 DEPTH,\n    CTE_RESULT.PARENT_OWNER,\n    CTE_RESULT.PARENT_TYPE,\n    CTE_RESULT.CHILD_TYPE,\n    CTE_RESULT.ATTR_NO,\n    CTE_RESULT.CHILD_TYPE_OWNER,\n    CTE_RESULT.ATTR_TYPE_CODE,\n    CTE_RESULT.LENGTH,\n    CTE_RESULT.NUMBER_PRECISION,\n    CTE_RESULT.SCALE,\n    CTE_RESULT.CHARACTER_SET_NAME\n  FROM CTE_RESULT INNER JOIN CTE ON CTE_RESULT.PARENT_TYPE = CTE.CHILD_TYPE\n)\nSELECT * FROM CTE\n);";
    private Map<String, Integer> indexMap;
    private int isolationLevel = 2;
    private static ReentrantLock threadLock = new ReentrantLock();
    private static Thread lbThread = null;
    private boolean remarksReporting = false;

    public OceanBaseConnection(Protocol protocol) {
        this.protocol = protocol;
        this.options = protocol.getOptions();
        this.canUseServerTimeout = protocol.versionGreaterOrEqual(10, 1, 2);
        this.sessionStateAware = protocol.sessionStateAware();
        this.nullCatalogMeansCurrent = this.options.nullCatalogMeansCurrent;
        if (this.options.cacheCallableStmts) {
            this.callableStatementCache = CallableStatementCache.newInstance(this.options.callableStmtCacheSize);
        }
        this.lock = protocol.getLock();
        this.exceptionFactory = ExceptionFactory.of(this.getServerThreadId(), this.options);
        this.complexDataCache = new LRUCache(50);
        this.urlParser = protocol.getUrlParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OceanBaseConnection(UrlParser urlParser, GlobalStateInfo globalInfo, boolean flag) throws SQLException {
        try {
            threadLock.lock();
            Protocol protocol = Utils.retrieveProxy(urlParser, globalInfo);
            this.urlParser = urlParser;
            this.globalStateInfo = globalInfo;
            this.protocol = protocol;
            this.options = protocol.getOptions();
            this.canUseServerTimeout = protocol.versionGreaterOrEqual(10, 1, 2);
            this.sessionStateAware = protocol.sessionStateAware();
            this.nullCatalogMeansCurrent = this.options.nullCatalogMeansCurrent;
            if (this.options.cacheCallableStmts) {
                this.callableStatementCache = CallableStatementCache.newInstance(this.options.callableStmtCacheSize);
            }
            this.lock = protocol.getLock();
            this.exceptionFactory = ExceptionFactory.of(this.getServerThreadId(), this.options);
            this.complexDataCache = new LRUCache(50);
        }
        finally {
            threadLock.unlock();
        }
    }

    public static OceanBaseConnection newConnection(UrlParser urlParser, GlobalStateInfo globalInfo) throws SQLException {
        if (urlParser.getOptions().pool) {
            return Pools.retrievePool(urlParser).getConnection();
        }
        Protocol protocol = Utils.retrieveProxy(urlParser, globalInfo);
        OceanBaseConnection conn = new OceanBaseConnection(protocol);
        return conn;
    }

    public static String quoteIdentifier(String string) {
        return "`" + string.replaceAll("`", "``") + "`";
    }

    @Deprecated
    public static String unquoteIdentifier(String string) {
        if (string != null && string.startsWith("`") && string.endsWith("`") && string.length() >= 2) {
            return string.substring(1, string.length() - 1).replace("``", "`");
        }
        return string;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkConnection();
        return new OceanBaseStatement(this, 1003, 1007, this.exceptionFactory);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new OceanBaseStatement(this, resultSetType, resultSetConcurrency, this.exceptionFactory);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new OceanBaseStatement(this, resultSetType, resultSetConcurrency, this.exceptionFactory);
    }

    private void checkConnection() throws SQLException {
        if (this.protocol.isExplicitClosed()) {
            throw this.exceptionFactory.create("createStatement() is called on closed connection", "08000");
        }
        if (this.protocol.isClosed() && this.protocol.getProxy() != null) {
            this.lock.lock();
            try {
                this.protocol.getProxy().reconnect();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public ClientSidePreparedStatement clientPrepareStatement(String sql) throws SQLException {
        return new ClientSidePreparedStatement(this, sql, 1003, 1007, 1, this.exceptionFactory);
    }

    public ServerSidePreparedStatement serverPrepareStatement(String sql) throws SQLException {
        return new ServerSidePreparedStatement(false, this, sql, 1003, 1007, 1, this.exceptionFactory);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.internalPrepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.internalPrepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.internalPrepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.internalPrepareStatement(sql, 1003, 1007, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    private String getCachedSql(String originSql) throws SQLException {
        if (StringCacheUtil.sqlStringCache == null) {
            return originSql;
        }
        String sqlCache = StringCacheUtil.sqlStringCache.getIfPresent(originSql);
        if (sqlCache == null) {
            StringCacheUtil.sqlStringCache.put(originSql, originSql);
            sqlCache = originSql;
        }
        return sqlCache;
    }

    private PreparedStatement internalPrepareStatement(String sql, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys) throws SQLException {
        if (sql != null) {
            String sqlQuery;
            block8: {
                sqlQuery = Utils.nativeSql(sql, this.protocol);
                if (this.options.useSqlStringCache) {
                    sqlQuery = this.getCachedSql(sqlQuery);
                }
                if (this.options.useServerPrepStmts && PREPARABLE_STATEMENT_PATTERN_MYSQL.matcher(sqlQuery).find() && !this.protocol.isOracleMode() || this.options.useServerPrepStmts && this.protocol.isOracleMode()) {
                    this.checkConnection();
                    try {
                        if (this.protocol.isOracleMode() && this.options.supportNameBinding) {
                            sqlQuery = Utils.trimSQLString(sqlQuery, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), true);
                        }
                        ServerSidePreparedStatement ret = new ServerSidePreparedStatement(false, this, sqlQuery, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys, this.exceptionFactory);
                        return ret;
                    }
                    catch (SQLNonTransientConnectionException e) {
                        throw e;
                    }
                    catch (SQLException e) {
                        if (this.options.emulateUnsupportedPstmts) break block8;
                        throw e;
                    }
                }
            }
            if (this.protocol.isOracleMode() && this.options.supportNameBinding) {
                sqlQuery = Utils.trimSQLString(sqlQuery, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), true);
            }
            ClientSidePreparedStatement ret = new ClientSidePreparedStatement(this, sqlQuery, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys, this.exceptionFactory);
            return ret;
        }
        throw new SQLException("SQL value can not be NULL");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String arguments;
        this.checkConnection();
        String querySetToServer = sql;
        Matcher matcher = CALLABLE_STATEMENT_PATTERN.matcher(querySetToServer);
        if (this.protocol.isOracleMode() && !matcher.matches()) {
            if (this.options.supportNameBinding) {
                querySetToServer = Utils.trimSQLString(sql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), true);
            }
            return new OceanBaseProcedureStatement(false, querySetToServer, this, "", null, null, resultSetType, resultSetConcurrency, this.exceptionFactory, true);
        }
        if (!matcher.matches()) {
            throw new SQLSyntaxErrorException("invalid callable syntax. must be like {[?=]call <procedure/function name>[(?,?, ...)]}\n but was : " + sql);
        }
        querySetToServer = matcher.group(2);
        boolean isFunction = matcher.group(3) != null;
        String databaseAndProcedure = matcher.group(8) == null ? null : matcher.group(8).trim();
        String database = matcher.group(10) == null ? null : matcher.group(10).trim();
        String procedureName = matcher.group(13) == null ? null : matcher.group(13).trim();
        String string = arguments = matcher.group(16) == null ? null : matcher.group(16).trim();
        if (database == null && this.sessionStateAware) {
            database = this.protocol.getDatabase();
        }
        if (database != null && this.options.cacheCallableStmts) {
            CallableStatement callableStatement;
            CallableStatementCacheKey cacheKey = new CallableStatementCacheKey(database, querySetToServer);
            if (this.callableStatementCache.containsKey(cacheKey)) {
                try {
                    callableStatement = (CallableStatement)this.callableStatementCache.get(cacheKey);
                    if (callableStatement != null) {
                        return ((CloneableCallableStatement)callableStatement).clone(this);
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
            if (this.protocol.isOracleMode() && this.options.supportNameBinding && isFunction && arguments != null) {
                arguments = Utils.trimSQLString(arguments, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), false);
            }
            callableStatement = this.createNewCallableStatement(querySetToServer, procedureName, isFunction, databaseAndProcedure, database, arguments, resultSetType, resultSetConcurrency, this.exceptionFactory);
            this.callableStatementCache.put(cacheKey, callableStatement);
            return callableStatement;
        }
        return this.createNewCallableStatement(querySetToServer, procedureName, isFunction, databaseAndProcedure, database, arguments, resultSetType, resultSetConcurrency, this.exceptionFactory);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql);
    }

    private CallableStatement createNewCallableStatement(String query, String procedureName, boolean isFunction, String databaseAndProcedure, String database, String arguments, int resultSetType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        if (isFunction) {
            if (!this.getProtocol().isOracleMode()) {
                return new OceanBaseFunctionStatement(this, database, databaseAndProcedure, arguments == null ? "()" : arguments, resultSetType, resultSetConcurrency, exceptionFactory);
            }
            return new OceanBaseProcedureStatement(true, "BEGIN ?:=" + databaseAndProcedure + (arguments == null ? "()" : arguments) + ";END;", this, procedureName, database, arguments, resultSetType, resultSetConcurrency, exceptionFactory);
        }
        if (databaseAndProcedure != null && arguments == null) {
            String callableSql = "call " + databaseAndProcedure + "()";
            return new OceanBaseProcedureStatement(false, callableSql, this, procedureName, database, arguments, resultSetType, resultSetConcurrency, exceptionFactory);
        }
        return new OceanBaseProcedureStatement(false, query, this, procedureName, database, arguments, resultSetType, resultSetConcurrency, exceptionFactory);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return Utils.nativeSql(sql, this.protocol);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.protocol.getAutocommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.protocol.setAutoCommit(autoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        block15: {
            this.lock.lock();
            try {
                if (!this.protocol.inTransaction()) break block15;
                try (Statement st = this.createStatement();){
                    st.execute("COMMIT");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        block16: {
            if (this.getAutoCommit()) {
                throw new SQLException("Can't call rollback when autocommit enable");
            }
            this.lock.lock();
            try {
                if (!this.protocol.inTransaction()) break block16;
                try (Statement st = this.createStatement();){
                    st.execute("ROLLBACK");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Can't call rollback when autocommit enable");
        }
        try (Statement st = this.createStatement();){
            if (!this.protocol.isOracleMode()) {
                st.execute("ROLLBACK TO SAVEPOINT `" + savepoint.getSavepointName() + "`");
            } else {
                st.execute("ROLLBACK TO " + savepoint.getSavepointName());
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.pooledConnection != null) {
            if (!this.getAutoCommit()) {
                this.rollback();
            }
            this.pooledConnection.fireConnectionClosed();
            return;
        }
        this.protocol.closeExplicit();
    }

    @Override
    public boolean isClosed() {
        return this.protocol.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new OceanBaseDatabaseMetaData(this, this.protocol.getUrlParser());
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.protocol.getReadonly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            logger.debug("conn={}({}) - set read-only to value {} {}", this.protocol.getServerThreadId(), this.protocol.isMasterConnection() ? "M" : "S", readOnly);
            this.stateFlag |= 4;
            this.protocol.setReadonly(readOnly);
        }
        catch (SQLException e) {
            throw this.exceptionFactory.create(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.getProtocol().isOracleMode()) {
            return null;
        }
        return this.protocol.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.getProtocol().isOracleMode()) {
            return;
        }
        if (catalog == null) {
            throw new SQLException("The catalog name may not be null", "XAE05");
        }
        if (catalog.equals(this.protocol.getCatalog())) {
            return;
        }
        try {
            this.stateFlag |= 2;
            this.protocol.setCatalog(catalog);
        }
        catch (SQLException e) {
            throw this.exceptionFactory.create(e);
        }
    }

    public boolean isServerMariaDb() throws SQLException {
        return this.protocol.isServerMariaDb();
    }

    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        return this.protocol.versionGreaterOrEqual(major, minor, patch);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.protocol.getTransactionIsolationLevel();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.protocol.isOracleMode() && level != 2 && level != 8) {
            throw this.exceptionFactory.create("Unsupported transaction isolation level by OracleModel");
        }
        try {
            this.stateFlag |= 0x10;
            this.protocol.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw this.exceptionFactory.create(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.warningsCleared || this.isClosed() || !this.protocol.hasWarnings() && this.protocol.isOracleMode()) {
            return null;
        }
        if (this.protocol.isOracleMode()) {
            return new SQLWarning("The execution is complete, but with warnings");
        }
        SQLWarning last = null;
        SQLWarning first = null;
        try (Statement st = this.createStatement();
             ResultSet rs = st.executeQuery("show warnings");){
            while (rs.next()) {
                int code = rs.getInt(2);
                String message = rs.getString(3);
                SQLWarning warning = new SQLWarning(message, null, code);
                if (first == null) {
                    first = warning;
                    last = warning;
                    continue;
                }
                last.setNextWarning(warning);
                last = warning;
            }
        }
        return first;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw this.exceptionFactory.create("Connection.clearWarnings cannot be called on a closed connection");
        }
        this.warningsCleared = true;
    }

    public void reenableWarnings() {
        this.warningsCleared = false;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.typeMap != null && this.typeMap.size() != 0) {
            Set<String> set = this.typeMap.keySet();
            set.forEach(s -> map.put((String)s, this.typeMap.get(s)));
        }
        this.typeMap = map;
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        String randomName = "";
        if (this.protocol.isOracleMode()) {
            if (this.getAutoCommit()) {
                throw new SQLException("Unable to set a savepoint with auto-commit enabled");
            }
            for (int i = 0; i < 10; ++i) {
                char c = (char)(Math.random() * 26.0 + 97.0);
                randomName = randomName + c;
            }
        } else {
            randomName = UUID.randomUUID().toString();
        }
        return this.setSavepoint(randomName);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        OceanBaseSavepoint savepoint = new OceanBaseSavepoint(name);
        try (Statement st = this.createStatement();){
            if (this.protocol.isOracleMode()) {
                st.execute("SAVEPOINT " + savepoint.getSavepointName());
            } else {
                st.execute("SAVEPOINT `" + savepoint.getSavepointName() + "`");
            }
        }
        return savepoint;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try (Statement st = this.createStatement();){
            st.execute("RELEASE SAVEPOINT `" + savepoint.getSavepointName() + "`");
        }
    }

    @Override
    public java.sql.Clob createClob() {
        return new Clob();
    }

    @Override
    public java.sql.Blob createBlob() {
        return new Blob();
    }

    @Override
    public NClob createNClob() {
        return new JDBC4NClob("", null);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.exceptionFactory.notSupported("SQLXML type is not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("the value supplied for timeout is negative");
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.protocol.isValid(timeout * 1000);
        }
        catch (SQLException e) {
            return false;
        }
    }

    private void checkClientClose(String name) throws SQLClientInfoException {
        if (this.protocol.isExplicitClosed()) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException("setClientInfo() is called on closed connection", failures);
        }
    }

    private void checkClientReconnect(String name) throws SQLClientInfoException {
        if (this.protocol.isClosed() && this.protocol.getProxy() != null) {
            this.lock.lock();
            try {
                this.protocol.getProxy().reconnect();
            }
            catch (SQLException sqle) {
                HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException("Connection closed", failures, (Throwable)sqle);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void checkClientValidProperty(String name) throws SQLClientInfoException {
        if (name == null || !"ApplicationName".equals(name) && !"ClientUser".equals(name) && !"ClientHostname".equals(name)) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException("setClientInfo() parameters can only be \"ApplicationName\",\"ClientUser\" or \"ClientHostname\", but was : " + name, failures);
        }
    }

    private String buildClientQuery(String name, String value) {
        StringBuilder escapeQuery = new StringBuilder("SET @").append(name).append("=");
        if (value == null) {
            escapeQuery.append("null");
        } else {
            int charsOffset;
            escapeQuery.append("'");
            int charsLength = value.length();
            if (this.protocol.noBackslashEscapes()) {
                for (charsOffset = 0; charsOffset < charsLength; ++charsOffset) {
                    char charValue = value.charAt(charsOffset);
                    if (charValue == '\'') {
                        escapeQuery.append('\'');
                    }
                    escapeQuery.append(charValue);
                }
            } else {
                while (charsOffset < charsLength) {
                    char charValue = value.charAt(charsOffset);
                    if (charValue == '\'' || charValue == '\\' || charValue == '\"' || charValue == '\u0000') {
                        escapeQuery.append('\\');
                    }
                    escapeQuery.append(charValue);
                    ++charsOffset;
                }
            }
            escapeQuery.append("'");
        }
        return escapeQuery.toString();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.checkClientClose(name);
        this.checkClientReconnect(name);
        this.checkClientValidProperty(name);
        try {
            Statement statement = this.createStatement();
            statement.execute(this.buildClientQuery(name, value));
        }
        catch (SQLException sqle) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException("unexpected error during setClientInfo", failures, (Throwable)sqle);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkConnection();
        String sql = this.protocol.isOracleMode() ? "SELECT @ApplicationName, @ClientUser, @ClientHostname from dual" : "SELECT @ApplicationName, @ClientUser, @ClientHostname";
        Properties properties = new Properties();
        try (Statement statement = this.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            if (rs.next()) {
                if (rs.getString(1) != null) {
                    properties.setProperty("ApplicationName", rs.getString(1));
                }
                if (rs.getString(2) != null) {
                    properties.setProperty("ClientUser", rs.getString(2));
                }
                if (rs.getString(3) != null) {
                    properties.setProperty("ClientHostname", rs.getString(3));
                }
                Properties properties2 = properties;
                return properties2;
            }
        }
        properties.setProperty("ApplicationName", null);
        properties.setProperty("ClientUser", null);
        properties.setProperty("ClientHostname", null);
        return properties;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> propertiesExceptions = new HashMap<String, ClientInfoStatus>();
        for (String name : new String[]{"ApplicationName", "ClientUser", "ClientHostname"}) {
            try {
                this.setClientInfo(name, properties.getProperty(name));
            }
            catch (SQLClientInfoException e) {
                propertiesExceptions.putAll(e.getFailedProperties());
            }
        }
        if (!propertiesExceptions.isEmpty()) {
            String errorMsg = "setClientInfo errors : the following properties where not set : " + propertiesExceptions.keySet();
            throw new SQLClientInfoException(errorMsg, propertiesExceptions);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkConnection();
        if (!("ApplicationName".equals(name) || "ClientUser".equals(name) || "ClientHostname".equals(name))) {
            throw new SQLException("name must be \"ApplicationName\", \"ClientUser\" or \"ClientHostname\", but was \"" + name + "\"");
        }
        String sql = this.protocol.isOracleMode() ? "SELECT @" + name + " from dual" : "SELECT @" + name;
        try (Statement statement = this.createStatement();
             ResultSet rs = statement.executeQuery(sql);){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (!this.getProtocol().isOracleMode()) {
            throw this.exceptionFactory.notSupported("Array type is not supported");
        }
        boolean fetchTypeFromRemote = true;
        ComplexDataType attrType = null;
        if (this.getCacheComplexData()) {
            LRUCache lRUCache = this.complexDataCache;
            synchronized (lRUCache) {
                attrType = (ComplexDataType)this.complexDataCache.get(typeName.toUpperCase());
                if (null != attrType && attrType.isValid()) {
                    fetchTypeFromRemote = false;
                } else if (null == attrType && ComplexDataType.isBaseDataType(ComplexDataType.getObComplexType(typeName))) {
                    fetchTypeFromRemote = false;
                    attrType = new ComplexDataType(typeName, this.getSchema(), ComplexDataType.getObComplexType(typeName));
                }
            }
        }
        if (fetchTypeFromRemote) {
            attrType = this.getComplexDataTypeFromRemote(typeName);
        }
        if (attrType.getType() == 4) {
            throw this.exceptionFactory.notSupported("array element is still array is not supported");
        }
        ComplexDataType parentType = new ComplexDataType("", this.getSchema(), 4);
        parentType.setAttrCount(1);
        parentType.setAttrType(0, attrType);
        ArrayImpl array = new ArrayImpl(parentType);
        array.setAttrData(elements);
        return array;
    }

    public boolean getCacheComplexData() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recacheComplexDataType(ComplexDataType type) {
        Protocol protocol = this.protocol;
        synchronized (protocol) {
            LRUCache lRUCache = this.complexDataCache;
            synchronized (lRUCache) {
                this.complexDataCache.put(type.getTypeName().toUpperCase(), type);
            }
        }
    }

    public ComplexDataType getComplexDataType(String typeName) throws SQLException {
        ComplexDataType type = null;
        type = this.getComplexDataTypeFromCache(typeName);
        if (null != type && type.isValid()) {
            return type;
        }
        type = this.getComplexDataTypeFromRemote(typeName);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComplexDataType getComplexDataTypeFromCache(String typeName) {
        LRUCache lRUCache = this.complexDataCache;
        synchronized (lRUCache) {
            return (ComplexDataType)this.complexDataCache.get(typeName.toUpperCase());
        }
    }

    private Connection getComplexConnection() throws SQLException {
        if (null == this.complexConnection || this.complexConnection.isClosed()) {
            this.complexConnection = new OceanBaseConnection(this.protocol.getUrlParser(), this.globalStateInfo, true);
        }
        return this.complexConnection;
    }

    public ComplexDataType getComplexDataTypeFromRemote(String typeName) throws SQLException {
        Connection conn = this.getComplexConnection();
        PreparedStatement ps = conn.prepareStatement(complexTypeSql, 1004, 1007);
        ps.setString(1, typeName.toUpperCase());
        ps.setString(2, typeName.toUpperCase());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            rs.beforeFirst();
        } else {
            rs.close();
            ps.close();
            String tmpString = null;
            tmpString = typeName.startsWith("DBMS_XA") ? "'SYS'" : "SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA')";
            String complexAllTypeSql = "SELECT\n    0 DEPTH,\n    NULL PARENT_OWNER,\n    NULL PARENT_TYPE,\n    to_char(TYPE_NAME) CHILD_TYPE,\n    0 ATTR_NO,\n    OWNER CHILD_TYPE_OWNER,\n    A.TYPECODE ATTR_TYPE_CODE,\n    NULL LENGTH,\n    NULL NUMBER_PRECISION,\n    NULL SCALE,\n    NULL CHARACTER_SET_NAME\n  FROM\n    ALL_TYPES A WHERE TYPE_NAME = ? AND OWNER = " + tmpString + "\n" + "  UNION\n" + "  (\n" + "  WITH\n" + "  CTE_RESULT(PARENT_OWNER, PARENT_TYPE, CHILD_TYPE, ATTR_NO, CHILD_TYPE_OWNER, ATTR_TYPE_CODE, LENGTH, NUMBER_PRECISION, SCALE, CHARACTER_SET_NAME)\n" + "  AS (\n" + "      SELECT\n" + "        B.OWNER PARENT_OWNER,\n" + "        B.TYPE_NAME PARENT_TYPE,\n" + "        B.ELEM_TYPE_NAME CHILD_TYPE,\n" + "        0 ATTR_NO,\n" + "        B.ELEM_TYPE_OWNER CHILD_TYPE_OWNER,\n" + "        NVL(A.TYPECODE, B.ELEM_TYPE_NAME) AS ATTR_TYPE_CODE,\n" + "        B.LENGTH LENGTH,\n" + "        B.NUMBER_PRECISION NUMBER_PRECISION,\n" + "        B.SCALE SCALE,\n" + "        B.CHARACTER_SET_NAME CHARACTER_SET_NAME\n" + "      FROM\n" + "        ALL_COLL_TYPES B LEFT JOIN ALL_TYPES A ON A.TYPE_NAME = B.ELEM_TYPE_NAME AND A.OWNER = B.ELEM_TYPE_OWNER\n" + "      UNION\n" + "      SELECT\n" + "        B.OWNER PARENT_OWNER,\n" + "        B.TYPE_NAME PARENT_TYPE,\n" + "        B.ATTR_TYPE_NAME CHILD_TYPE,\n" + "        B.ATTR_NO ATTR_NO,\n" + "        B.ATTR_TYPE_OWNER CHILD_TYPE_OWNER,\n" + "        NVL(A.TYPECODE, B.ATTR_TYPE_NAME) AS ATTR_TYPE_CODE,\n" + "        B.LENGTH LENGTH,\n" + "        B.NUMBER_PRECISION NUMBER_PRECISION,\n" + "        B.SCALE SCALE,\n" + "        B.CHARACTER_SET_NAME CHARACTER_SET_NAME\n" + "      FROM ALL_TYPE_ATTRS B LEFT JOIN ALL_TYPES A ON A.TYPE_NAME = B.ATTR_TYPE_NAME AND A.OWNER = B.ATTR_TYPE_OWNER ORDER BY ATTR_NO\n" + "  ) ,\n" + "  CTE(DEPTH, PARENT_OWNER, PARENT_TYPE, CHILD_TYPE, ATTR_NO, CHILD_TYPE_OWNER, ATTR_TYPE_CODE, LENGTH, NUMBER_PRECISION, SCALE, CHARACTER_SET_NAME)\n" + "  AS (\n" + "    SELECT\n" + "      1 DEPTH,\n" + "      PARENT_OWNER,\n" + "      PARENT_TYPE,\n" + "      CHILD_TYPE,\n" + "      ATTR_NO,\n" + "      CHILD_TYPE_OWNER,\n" + "      ATTR_TYPE_CODE,\n" + "      LENGTH,\n" + "      NUMBER_PRECISION,\n" + "      SCALE, CHARACTER_SET_NAME\n" + "    FROM CTE_RESULT WHERE PARENT_TYPE = ? AND PARENT_OWNER = " + tmpString + "\n" + "    UNION ALL\n" + "    SELECT\n" + "      DEPTH + 1 DEPTH,\n" + "      CTE_RESULT.PARENT_OWNER,\n" + "      CTE_RESULT.PARENT_TYPE,\n" + "      CTE_RESULT.CHILD_TYPE,\n" + "      CTE_RESULT.ATTR_NO,\n" + "      CTE_RESULT.CHILD_TYPE_OWNER,\n" + "      CTE_RESULT.ATTR_TYPE_CODE,\n" + "      CTE_RESULT.LENGTH,\n" + "      CTE_RESULT.NUMBER_PRECISION,\n" + "      CTE_RESULT.SCALE,\n" + "      CTE_RESULT.CHARACTER_SET_NAME\n" + "    FROM CTE_RESULT INNER JOIN CTE ON CTE_RESULT.PARENT_TYPE = CTE.CHILD_TYPE AND CTE_RESULT.PARENT_OWNER = CTE.CHILD_TYPE_OWNER\n" + "  )\n" + "  SELECT * FROM CTE\n" + "  );";
            ps = conn.prepareStatement(complexAllTypeSql, 1004, 1007);
            ps.setString(1, typeName.toUpperCase());
            ps.setString(2, typeName.toUpperCase());
            rs = ps.executeQuery();
        }
        while (rs.next()) {
            ComplexDataType complexType = null;
            String childTypeName = rs.getString(4);
            int type = ComplexDataType.getObComplexType(rs.getString(7));
            if (3 == type || 4 == type) {
                complexType = this.getComplexDataTypeFromCache(childTypeName);
                if (null == complexType) {
                    complexType = new ComplexDataType(childTypeName, rs.getString(6), type);
                    complexType.setValid(false);
                    this.recacheComplexDataType(complexType);
                } else {
                    complexType.setValid(false);
                }
            } else {
                complexType = this.getComplexDataTypeFromCache(childTypeName);
                if (null == complexType) {
                    complexType = new ComplexDataType(childTypeName, "", type);
                    complexType.setValid(true);
                    this.recacheComplexDataType(complexType);
                }
            }
            if (rs.getInt(1) <= 0) continue;
            String parentTypeName = rs.getString(3);
            ComplexDataType parentType = this.getComplexDataTypeFromCache(parentTypeName);
            int attrIndex = rs.getInt(5);
            if (3 != parentType.getType() || parentType.getAttrCount() >= attrIndex) continue;
            parentType.setAttrCount(attrIndex);
        }
        rs.first();
        do {
            if (rs.getInt(1) <= 0) continue;
            String parentTypeName = rs.getString(3);
            ComplexDataType parentComplexType = this.getComplexDataTypeFromCache(parentTypeName);
            String attrTypeName = rs.getString(4);
            ComplexDataType attrComplexType = this.getComplexDataTypeFromCache(attrTypeName);
            if (parentComplexType.getType() == 3) {
                parentComplexType.setAttrType(rs.getInt(5) - 1, attrComplexType);
                parentComplexType.incInitAttrCount();
                if (parentComplexType.getInitAttrCount() != parentComplexType.getAttrCount()) continue;
                parentComplexType.setValid(true);
                continue;
            }
            if (parentComplexType.getType() != 4) continue;
            parentComplexType.setAttrCount(1);
            parentComplexType.setAttrType(0, attrComplexType);
            parentComplexType.setValid(true);
        } while (rs.next());
        rs.close();
        ps.close();
        conn.close();
        return this.getComplexDataTypeFromCache(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (!this.getProtocol().isOracleMode()) {
            throw this.exceptionFactory.notSupported("Struct type is not supported");
        }
        boolean fetchTypeFromRemote = true;
        ComplexDataType type = null;
        if (this.getCacheComplexData()) {
            LRUCache lRUCache = this.complexDataCache;
            synchronized (lRUCache) {
                type = (ComplexDataType)this.complexDataCache.get(typeName.toUpperCase());
                if (null != type && type.isValid()) {
                    fetchTypeFromRemote = false;
                }
            }
        }
        if (fetchTypeFromRemote) {
            type = this.getComplexDataTypeFromRemote(typeName);
        }
        StructImpl struct = new StructImpl(type);
        struct.setAttrData(attributes);
        return struct;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Deprecated
    public String getUsername() {
        return this.protocol.getUsername();
    }

    @Deprecated
    public String getHostname() {
        return this.protocol.getHost();
    }

    @Deprecated
    public int getPort() {
        return this.protocol.getPort();
    }

    protected boolean getPinGlobalTxToPhysicalConnection() {
        return this.protocol.getPinGlobalTxToPhysicalConnection();
    }

    public void setHostFailed() {
        if (this.protocol.getProxy() == null) {
            this.protocol.setHostFailedWithoutProxy();
        }
    }

    public int getLowercaseTableNames() throws SQLException {
        if (this.lowercaseTableNames == -1) {
            try (Statement st = this.createStatement();
                 ResultSet rs = st.executeQuery("select @@lower_case_table_names");){
                rs.next();
                this.lowercaseTableNames = rs.getInt(1);
            }
        }
        return this.lowercaseTableNames;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        SQLPermission sqlPermission = new SQLPermission("callAbort");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(sqlPermission);
        }
        if (executor == null) {
            throw this.exceptionFactory.create("Cannot abort the connection: null executor passed");
        }
        executor.execute(this.protocol::abort);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.protocol.getTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.protocol.isOracleMode()) {
            return this.getDatabase().toUpperCase();
        }
        return this.getCatalog();
    }

    public String getDatabase() {
        return this.urlParser.getDatabase();
    }

    @Override
    public void setSchema(String arg0) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.isClosed()) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called on a closed connection");
        }
        if (milliseconds < 0) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called with a negative timeout");
        }
        SQLPermission sqlPermission = new SQLPermission("setNetworkTimeout");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(sqlPermission);
        }
        try {
            this.stateFlag |= 1;
            this.protocol.setTimeout(milliseconds);
        }
        catch (SocketException se) {
            throw this.exceptionFactory.create("Cannot set the network timeout", se);
        }
    }

    public long getServerThreadId() {
        return this.protocol.getServerThreadId();
    }

    public boolean canUseServerTimeout() {
        return this.canUseServerTimeout;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void reset() throws SQLException {
        boolean useComReset;
        boolean bl = useComReset = this.options.useResetConnection && this.protocol.isServerMariaDb() && (this.protocol.versionGreaterOrEqual(10, 3, 13) || this.protocol.getMajorServerVersion() == 10 && this.protocol.getMinorServerVersion() == 2 && this.protocol.versionGreaterOrEqual(10, 2, 22));
        if (useComReset) {
            this.protocol.reset();
        }
        if (this.stateFlag != 0) {
            try {
                if ((this.stateFlag & 1) != 0) {
                    this.setNetworkTimeout(null, this.options.socketTimeout);
                }
                if ((this.stateFlag & 8) != 0) {
                    this.setAutoCommit(this.options.autocommit);
                }
                if ((this.stateFlag & 2) != 0) {
                    this.protocol.resetDatabase();
                }
                if ((this.stateFlag & 4) != 0) {
                    this.setReadOnly(false);
                }
                if (!useComReset && (this.stateFlag & 0x10) != 0) {
                    this.setTransactionIsolation(this.defaultTransactionIsolation);
                }
                this.stateFlag = 0;
            }
            catch (SQLException sqle) {
                throw this.exceptionFactory.create("error resetting connection");
            }
        }
        this.warningsCleared = true;
    }

    public boolean includeDeadLockInfo() {
        return this.options.includeInnodbStatusInDeadlockExceptions;
    }

    public boolean includeThreadsTraces() {
        return this.options.includeThreadDumpInDeadlockExceptions;
    }

    @Override
    public String getSessionTimeZone() {
        return this.sessionTimeZone.getID();
    }

    public Statement getMetadataSafeStatement() throws SQLException {
        Statement stmt = this.createStatement();
        if (stmt.getMaxRows() != 0) {
            stmt.setMaxRows(0);
        }
        stmt.setEscapeProcessing(false);
        if (stmt.getFetchSize() != 0) {
            stmt.setFetchSize(0);
        }
        return stmt;
    }

    @Override
    public void setSessionTimeZone(String zoneID) throws SQLException {
        this.checkConnection();
        if (this.protocol.isOracleMode()) {
            boolean needSetSessionTimeZone = true;
            TimeZone targetTimeZone = TimeZone.getTimeZone(zoneID);
            if (!this.protocol.isTZTablesImported()) {
                if (null != this.sessionTimeZone && targetTimeZone.getRawOffset() == this.sessionTimeZone.getRawOffset()) {
                    needSetSessionTimeZone = false;
                }
            } else if (null != this.sessionTimeZone && this.sessionTimeZone.getID().equals(zoneID)) {
                needSetSessionTimeZone = false;
            }
            if (needSetSessionTimeZone) {
                try (Statement stmt = this.getMetadataSafeStatement();){
                    String sql = String.format("alter session set time_zone = '%s'", zoneID);
                    stmt.execute(sql);
                    this.sessionTimeZone = targetTimeZone;
                }
            }
        } else {
            throw new SQLFeatureNotSupportedException();
        }
    }

    public boolean isInGlobalTx() {
        return this.isInGlobalTx;
    }

    public void setInGlobalTx(boolean flag) {
        this.isInGlobalTx = flag;
    }

    public long getLastPacketCostTime() throws SQLException {
        return this.protocol.getLastPacketCostTime();
    }

    public void networkStatistics(boolean flag) {
        this.protocol.setNetworkStatisticsFlag(flag);
    }

    public void clearNetworkStatistics() {
        this.protocol.clearNetworkStatistics();
    }

    public long getLastPacketResponseTimestamp() {
        return this.protocol.getLastPacketResponseTimestamp();
    }

    public long getLastPacketSendTimestamp() {
        return this.protocol.getLastPacketSendTimestamp();
    }

    @Override
    public void changeUser(String userName, String newPassword) throws SQLException {
        if (userName == null || userName.equals("")) {
            userName = "";
        }
        if (newPassword == null) {
            newPassword = "";
        }
        this.protocol.changeUser(userName, newPassword);
    }

    @Override
    public void setRemarksReporting(boolean value) {
        this.remarksReporting = value;
    }

    @Override
    public boolean getRemarksReporting() {
        return this.remarksReporting;
    }
}

