//流程引擎附加组件，选择当前用户所在组织的主管
define(['jquery', 'vue'], function ($, Vue) {
    return Vue.component('peac-manager', {
        props: {},
        data: function () {
            return {
                managers: [],      //可选处理人
                manager: ''
            }
        },
        template: '<div class="form-group col-xs-12">\
                        <label>选择处理人</label>\
                        <select class="form_control" v-model="manager">\
                            <option value="">请选择</option>\
                            <option :value="manager.id + \'::\' + manager.displayName" v-for="manager in managers">{{manager.displayName}}</option>\
                        </select>\
                    </div>',
        created: function () {
            //取当前用户直接领导
            var that = this;
            $.ajax({
                type: 'GET',
                url: '/api/user/pe/manager',
                success: function (data) {
                    that.managers = data.data;
                    if(that.managers.length == 1)
                        that.manager = that.managers[0].id + '::' + that.managers[0].displayName;
                }
            });
        },
        mounted: function () {
        },
        watch: {},
        computed: {},
        methods: {
            verifyValue: function () {
                if (this.manager == '') {
                    // alert('请选择处理人。');
                    layer.confirm('请选择处理人。',
                        {title:'提示',btn: ['确定'],closeBtn: 0 },
                        function(index){
                            layer.close(index);
                        });
                    return false;
                }
                return true;
            },
            getValue: function () {
                return this.manager;
            }
        }
    });
});
