package com.infoepoch.pms.dispatchassistant.domain.oa.organization;


import com.infoepoch.pms.dispatchassistant.common.component.AbstractCriteria;

import java.util.List;

/**
* OA组织查询条件类
*/
public class OaOrganizationCriteria extends AbstractCriteria {


    //region
    public boolean byOrgId() {
        return this.andMap.containsKey("OrgId");
    }

    private String orgId;

    public String getOrgId() {
        if (byOrgId())
            return orgId;
        return null;
    }

    public void setOrgId(String value) {
        this.orgId = value;
        this.andMap.put("OrgId", value);
    }
    //endregion

    //region
    public boolean byOrgCode() {
        return this.andMap.containsKey("OrgCode");
    }

    private String orgCode;

    public String getOrgCode() {
        if (byOrgCode())
            return orgCode;
        return null;
    }

    public void setOrgCode(String value) {
        this.orgCode = value;
        this.andMap.put("OrgCode", value);
    }
    //endregion

    // region

    private List<String> orgCodeList;

    public List<String> getOrgCodeList() {
        return orgCodeList;
    }

    public void setOrgCodeList(List<String> orgCodeList) {
        this.orgCodeList = orgCodeList;
    }

    // endregion

    //region
    public boolean byOrgName() {
        return this.andMap.containsKey("OrgName");
    }

    private String orgName;

    public String getOrgName() {
        if (byOrgName())
            return orgName;
        return null;
    }

    public void setOrgName(String value) {
        this.orgName = value;
        this.andMap.put("OrgName", value);
    }
    //endregion

    //region 模糊查询
    public boolean byOrgNameContain() {
        return this.andMap.containsKey("OrgNameContain");
    }

    private String orgNameContain;

    public String getOrgNameContain() {
        if (byOrgNameContain())
            return orgNameContain;
        return null;
    }

    public void setOrgNameContain(String value) {
        this.orgNameContain = value;
        this.andMap.put("OrgNameContain", value);
    }
    //endregion

    //region
    public boolean byOrgParentId() {
        return this.andMap.containsKey("OrgParentId");
    }

    private String orgParentId;

    public String getOrgParentId() {
        if (byOrgParentId())
            return orgParentId;
        return null;
    }

    public void setOrgParentId(String value) {
        this.orgParentId = value;
        this.andMap.put("OrgParentId", value);
    }
    //endregion

    //region
    public boolean byOrgStatus() {
        return this.andMap.containsKey("OrgStatus");
    }

    private String orgStatus;

    public String getOrgStatus() {
        if (byOrgStatus())
            return orgStatus;
        return null;
    }

    public void setOrgStatus(String value) {
        this.orgStatus = value;
        this.andMap.put("OrgStatus", value);
    }
    //endregion

    //region
    public boolean byOrgLevel() {
        return this.andMap.containsKey("OrgLevel");
    }

    private String orgLevel;

    public String getOrgLevel() {
        if (byOrgLevel())
            return orgLevel;
        return null;
    }

    public void setOrgLevel(String value) {
        this.orgLevel = value;
        this.andMap.put("OrgLevel", value);
    }
    //endregion

    //region
    public boolean byLastUpdateTime() {
        return this.andMap.containsKey("LastUpdateTime");
    }

    private String lastUpdateTime;

    public String getLastUpdateTime() {
        if (byLastUpdateTime())
            return lastUpdateTime;
        return null;
    }

    public void setLastUpdateTime(String value) {
        this.lastUpdateTime = value;
        this.andMap.put("LastUpdateTime", value);
    }
    //endregion

    //region
    public boolean byOrgRecordTime() {
        return this.andMap.containsKey("OrgRecordTime");
    }

    private String orgRecordTime;

    public String getOrgRecordTime() {
        if (byOrgRecordTime())
            return orgRecordTime;
        return null;
    }

    public void setOrgRecordTime(String value) {
        this.orgRecordTime = value;
        this.andMap.put("OrgRecordTime", value);
    }
    //endregion

    //region
    public boolean byOrgOaId() {
        return this.andMap.containsKey("OrgOaId");
    }

    private String orgOaId;

    public String getOrgOaId() {
        if (byOrgOaId())
            return orgOaId;
        return null;
    }

    public void setOrgOaId(String value) {
        this.orgOaId = value;
        this.andMap.put("OrgOaId", value);
    }
    //endregion

}
