package com.infoepoch.pms.dispatchassistant.domain.oa.organization;

import java.util.List;

/**
* OA组织仓储接口
*/
public interface IOaOrganizationRepository {
    /**
     * 新增
     * @param: [entity]
     */
    boolean insert(OaOrganization entity);

    /**
     * 更新
     * @param: [entity]
     */
    boolean update(OaOrganization entity);

    /**
     * 批量新增
     * @param: [entitys]
     */
    int[] batchInsert(List<OaOrganization> entitys);

    /**
     * 批量更新
     * @param: [entitys]
     */
    int[] batchUpdate(List<OaOrganization> entitys);

    /**
     * 删除
     * @param: [id]
     */
    boolean delete(String id);

    // region select

    /**
     * 根据Id查询
     * @param: [id]
     */
    OaOrganization selectById(String id);

    /**
     * 根据查询条件查询单个对象
     * @param: [criteria]
     */
    OaOrganization selectOneByCriteria(OaOrganizationCriteria criteria);

    /**
     * 根据查询条件查询对象集合
     * @param: [criteria]
     */
    List<OaOrganization> selectByCriteria(OaOrganizationCriteria criteria);

    /**
     * 根据查询条件分页查询对象结合
     * @param: [criteria, pageIndex, pageSize]
     */
    List<OaOrganization> selectCriteriaByPage(OaOrganizationCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询对象总记录数
     * @param: [criteria]
     */
    int selectCountByCriteria(OaOrganizationCriteria criteria);

    // endregion
}
