package com.infoepoch.pms.dispatchassistant.domain.langchain.record.conversation.line;


import java.util.List;

public interface IConversationLineRepository {

    /**
     * 插入
     *
     * @param entity
     */
    void insert(ConversationLine entity);

    /**
     * 批量插入
     *
     * @param list
     */
    void batchInsert(List<ConversationLine> list);

    /**
     * 更新
     *
     * @param entity
     */
    void update(ConversationLine entity);

    /**
     * 批量更新
     *
     * @param list
     */
    void batchUpdate(List<ConversationLine> list);

    // region 查询

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    ConversationLine selectById(String id);

    /**
     * 根据条件查询列表
     *
     * @param criteria
     * @return
     */
    List<ConversationLine> selectByCriteria(ConversationLineCriteria criteria);

    /**
     * 根据条件分页查询列表
     *
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<ConversationLine> selectByCriteriaPage(ConversationLineCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询列表总数量
     *
     * @param criteria
     * @return
     */
    int selectByCriteriaCount(ConversationLineCriteria criteria);

    // endregion 查询

}
