package com.infoepoch.pms.dispatchassistant.domain.basic.user;

import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;
import com.infoepoch.pms.dispatchassistant.domain.basic.user.organizationRela.UserOrganizationRela;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ValidationException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * 用户
 */
public class User implements Serializable {
    private static final long serialVersionUID = 2105695673309726179L;

    // region


    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setOrgConfirmStatus(Integer orgConfirmStatus) {
        this.orgConfirmStatus = orgConfirmStatus;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setBranchCompanyFlag(boolean branchCompanyFlag) {
        this.branchCompanyFlag = branchCompanyFlag;
    }

    /**
     * 获取
     * @return
     */
    public String getUniqueKey() {
        return this.organizationId + ":" + this.id;
    }

    /**
     * 取排序值
     */
    public Integer getDisplayOrderValue() {
        if (StringUtils.isBlank(displayOrder))
            return Integer.MAX_VALUE;
        return Integer.parseInt(displayOrder);
    }

    /**
     * 取排序值
     */
    public Integer displayOrderValue() {
        if (StringUtils.isBlank(id))
            return Integer.MAX_VALUE;
        return Integer.parseInt(id);
    }

    /**
     * 取显示名，有全名返回全名，否则返回用户名
     *
     * @return
     */
    public String getDisplayName() {
        if (!StringUtils.isBlank(fullname))
            return this.fullname;
        return this.username;
    }

    // endregion


    // region 构造方法

    public User() {
    }

    /**
     * 构造函数，新建
     */
    public User(String organizationId, UserType type, String position, String displayOrder, List<Integer> permissions
            , String username, String fullname, String sex, String mobile, String email, boolean disabled
            , String description, String jobNumber) {
        username = StringUtils.trim(username);
        if (StringUtils.isEmpty(username))
            throw new ValidationException("用户名不能为空。");

        if (type == null)
            throw new ValidationException("用户类型不能为空。");

        this.id = String.valueOf(SnowFlake.instant().nextId());
        this.organizationId = organizationId;
        this.type = type;
        this.position = position;
        this.displayOrder = displayOrder;
        this.permissions = permissions;
        this.username = username;
        this.fullname = fullname;
        this.sex = sex;
        this.mobile = mobile;
        this.email = email;
        this.disabled = disabled;
        this.description = description;
        this.jobNumber = jobNumber;
    }

    /**
     * 构造函数，还原
     */
    public User(String id, String organizationId, UserType type, String position, String displayOrder, List<Integer> permissions
            , String username, String fullname, String sex, String mobile, String email, boolean disabled
            , String description, String oaData, String hrData, String jobNumber, Integer orgConfirmStatus) {
        this.id = id;
        this.organizationId = organizationId;
        this.type = type;
        this.position = position;
        this.displayOrder = displayOrder;
        this.permissions = permissions;
        this.username = username;
        this.fullname = fullname;
        this.sex = sex;
        this.mobile = mobile;
        this.email = email;
        this.disabled = disabled;
        this.description = description;
        this.oaData = oaData;
        this.hrData = hrData;
        this.jobNumber = jobNumber;
        this.orgConfirmStatus = orgConfirmStatus;
    }

    /**
     * 仓储还原（关联组织关联表）
     *
     * @param id
     * @param organizationId
     * @param type
     * @param position
     * @param displayOrder
     * @param username
     * @param fullname
     * @param sex
     * @param mobile
     * @param email
     * @param disabled
     * @param description
     * @param oaData
     * @param hrData
     * @param jobNumber
     * @param orgConfirmStatus
     * @param organizationName
     */
    public User(String id, String organizationId, UserType type, String position, String displayOrder, String username, String fullname,
                String sex, String mobile, String email, boolean disabled, String description, String oaData, String hrData, String jobNumber,
                Integer orgConfirmStatus, String organizationName) {
        this.id = id;
        this.organizationId = organizationId;
        this.type = type;
        this.position = position;
        this.displayOrder = displayOrder;
        this.username = username;
        this.fullname = fullname;
        this.sex = sex;
        this.mobile = mobile;
        this.email = email;
        this.disabled = disabled;
        this.description = description;
        this.oaData = oaData;
        this.hrData = hrData;
        this.jobNumber = jobNumber;
        this.orgConfirmStatus = orgConfirmStatus;
        this.organizationName = organizationName;
    }

    //关联角色拉取用户列表专用
    public User(String id, String organizationId, String fullname) {
        this.id = id;
        this.organizationId = organizationId;
        this.fullname = fullname;
    }

    /**
     * 修改
     */
    public void modify(String organizationId, UserType type, String position, String displayOrder, List<Integer> permissions
            , String username, String fullname, String sex, String mobile, String email, boolean disabled
            , String description, String jobNumber, Integer orgConfirmStatus) {
        username = StringUtils.trim(username);
        if (StringUtils.isEmpty(username))
            throw new ValidationException("用户名不能为空。");

        if (type == null)
            throw new ValidationException("用户类型不能为空。");

        this.organizationId = organizationId;
        this.type = type;
        this.position = position;
        this.displayOrder = displayOrder;
        this.permissions = permissions;
        this.username = username;
        this.fullname = fullname;
        this.sex = sex;
        this.mobile = mobile;
        this.email = email;
        this.disabled = disabled;
        this.description = description;
        this.jobNumber = jobNumber;
        this.orgConfirmStatus = orgConfirmStatus;
    }

    /**
     * OA同步修改
     */
    public void modify(String organizationId, UserType type, String position, String displayOrder, String username, String fullname, String sex,
                       String mobile, String email, boolean disabled, String jobNumber, Integer orgConfirmStatus) {
        this.organizationId = organizationId;
        this.type = type;
        this.position = position;
        this.displayOrder = displayOrder;
        this.username = username;
        this.fullname = fullname;
        this.sex = sex;
        this.mobile = mobile;
        this.email = email;
        this.disabled = disabled;
        this.jobNumber = jobNumber;
        this.orgConfirmStatus = orgConfirmStatus;
    }

    // endregion 构造方法

    // region 额外属性

    /**
     * 用户组织关联列表
     */
    private List<UserOrganizationRela> userOrganizationRelaList;

    public List<UserOrganizationRela> getUserOrganizationRelaList() {
        return userOrganizationRelaList;
    }

    public void setUserOrganizationRelaList(List<UserOrganizationRela> userOrganizationRelaList) {
        this.userOrganizationRelaList = userOrganizationRelaList;
    }

    // endregion 额外属性

    // region 基础属性

    private String id;                  //id
    private String organizationId;      //所属组织id
    private UserType type;              //类型
    private String position;            //职位
    private String displayOrder;        //显示顺序
    private List<Integer> permissions;  //权限
    private String username;            //用户名
    private String fullname;            //全名
    private String sex;                 //性别
    private String mobile;              //移动电话
    private String email;               //电子邮箱
    private boolean disabled;           //是否禁用
    private String description;         //描述
    private String oaData;              //OA数据
    private String hrData;              //HR数据
    private String jobNumber;           // 工号
    private Integer orgConfirmStatus;   // 组织确认状态

    private String organizationName; // 部门名称

    private boolean branchCompanyFlag; // 分公司标识


    public String getId() {
        return id == null ? "" : id;
    }

    public String getOrganizationId() {
        return organizationId == null ? "" : organizationId;
    }

    public UserType getType() {
        return type;
    }

    public String getPosition() {
        return position == null ? "" : position;
    }

    public String getDisplayOrder() {
        return displayOrder == null ? "" : displayOrder;
    }

    public List<Integer> getPermissions() {
        return permissions;
    }

    public String getUsername() {
        return username == null ? "" : username;
    }

    public String getFullname() {
        return fullname == null ? "" : fullname;
    }

    public String getSex() {
        return sex == null ? "" : sex;
    }

    public String getMobile() {
        return mobile == null ? "" : mobile;
    }

    public String getEmail() {
        return email == null ? "" : email;
    }

    public boolean isDisabled() {
        return disabled;
    }

    public String getDescription() {
        return description == null ? "" : description;
    }

    public String getOaData() {
        return oaData == null ? "" : oaData;
    }

    public String getHrData() {
        return hrData == null ? "" : hrData;
    }

    public String getJobNumber() {
        return jobNumber;
    }

    public Integer getOrgConfirmStatus() {
        return orgConfirmStatus;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public boolean getBranchCompanyFlag() {
        return branchCompanyFlag;
    }

    // endregion 基础属性

    // region 重构方法

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        User user = (User) o;
        return disabled == user.disabled &&
                Objects.equals(id, user.id) &&
                Objects.equals(organizationId, user.organizationId) &&
                type == user.type &&
                Objects.equals(position, user.position) &&
                Objects.equals(displayOrder, user.displayOrder) &&
                Objects.equals(permissions, user.permissions) &&
                Objects.equals(username, user.username) &&
                Objects.equals(fullname, user.fullname) &&
                Objects.equals(sex, user.sex) &&
                Objects.equals(mobile, user.mobile) &&
                Objects.equals(email, user.email) &&
                Objects.equals(description, user.description) &&
                Objects.equals(oaData, user.oaData) &&
                Objects.equals(hrData, user.hrData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, organizationId, type, position, displayOrder, permissions, username, fullname, sex, mobile, email, disabled, description, oaData, hrData);
    }

    // endregion 重构方法

}
