package com.infoepoch.pms.dispatchassistant.domain.basic.user;

import java.util.List;

/**
 * 用户Repository接口
 */
public interface IUserRepository {

    /**
     * 根据ID查询用户
     *
     * @param id
     * @return
     */
    User selectById(String id);

    /*
     * 根据id集合查询
     */
    List<User> selectByIds(List<String> ids);

    /**
     * 根据用户名称查询用户信息
     *
     * @param username
     * @return
     */
    User selectByUsername(String username);

    /**
     * 查询密码
     *
     * @param id
     * @return
     */
    String selectPassword(String id);

    /**
     * 查询所有用户
     *
     * @return
     */
    List<User> selectAll();

    /**
     *
     * @param jobNumber
     * @return
     */
    User selectOneByJobNumber(String jobNumber);

    /**
     * 根据工号查询用户列表
     *
     * @param jobNumber
     * @return
     */
    List<User> selectByJobNumber(String jobNumber);

    /**
     * 根据工号查询用户
     *
     * @param jobNumber
     * @param disabledFlag
     * @return
     */
    User selectUserByJobNumber(String jobNumber, Boolean disabledFlag);

    /**
     * 根据条件查询用户列表
     *
     * @param criteria
     * @return
     */
    List<User> selectByCriteria(UserCriteria criteria);

    /**
     * 根据条件分页查询
     *
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<User> selectByCriteriaPage(UserCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询用户列表总数量
     *
     * @param criteria
     * @return
     */
    int selectByCriteriaCount(UserCriteria criteria);

    /**
     * 插入
     *
     * @param user
     */
    void insert(User user);

    /**
     * @param userList
     */
    void batchInsert(List<User> userList);

    /**
     * 更新
     *
     * @param user
     */
    void update(User user);

    /**
     * @param userList
     */
    void batchUpdate(List<User> userList);

    /**
     * 修改密码
     */
    void updatePassword(String id, String password);

    /**
     * 设置默认密码
     */
    void setDefaultPassword(String password);

    /**
     * 根据ID删除用户
     *
     * @param id
     */
    void deleteById(String id);

    /**
     * 删除所有用户
     */
    void truncate();

    /**
     * 根据组织ID和角色名称查询用户列表
     *
     * @param organizationId
     * @param roleId
     * @return
     */
    List<User> selectByOrganizationIdAndRole(List<String> organizationId, String roleId);

}
