package com.infoepoch.pms.dispatchassistant.domain.basic.user;

import java.util.List;

public interface IUserQueryRepository {

    /**
     * 根据条件查询用户列表
     *
     * @param criteria
     * @return
     */
    List<User> selectByCriteria(UserCriteria criteria);

    /**
     * 根据条件查询用户列表（分页）
     *
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<User> selectByCriteriaByPage(UserCriteria criteria, int pageIndex, int pageSize);

    /**
     * 根据条件查询用户列表总数量
     *
     * @param criteria
     * @return
     */
    int selectCountByCriteria(UserCriteria criteria);


    /**
     * 根据条件查询用户列表（分页）
     *
     * @param criteria
     * @param pageIndex
     * @param pageSize
     * @return
     */
    List<User> selectProvinceByCriteriaByPage(UserCriteria criteria, int pageIndex, int pageSize);


    /**
     * 根据条件查询用户列表
     *
     * @param criteria
     * @return
     */
    List<User> selectProvinceByCriteria(UserCriteria criteria);


    /**
     * 根据条件查询用户列表总数量
     *
     * @param criteria
     * @return
     */
    int selectProvinceCountByCriteria(UserCriteria criteria);

}
