package com.infoepoch.pms.dispatchassistant.domain.basic.todo;

import com.infoepoch.pms.dispatchassistant.common.component.SnowFlake;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ValidationException;
import java.util.Date;

/**
 * @author: wany
 * @desc: 待办
 * @time: 2019/11/5 08:53
 */
public class Todo {

    // region 属性修改方法

    public void setType(TodoType type) {
        this.type = type;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setSyncStatus(Integer syncStatus) {
        this.syncStatus = syncStatus;
    }

    /**
     * @Description: 重置url
     * @Param: [url]
     * @Author: zhangyd
     */
    public void resetUrl(String url) {
        this.url = url;
    }

    /**
     * 重置发送时间
     *
     * @param sendTime
     */
    public void modifySendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    // endregion 属性修改方法

    // region 事件

    public void create() {
        this.id = SnowFlake.instant().nextId().toString();
    }

    /**
     * 修改
     */
    public void modify(String documentType, String domainId, String stage, String drafter, String drafterName, TodoType type, TodoLevel level,
                       String title, String url, String sender, String senderName, String receiver, String receiverName,
                       Date actionTime, String additionalData, Integer syncStatus) {
        this.documentType = documentType;
        this.domainId = domainId;
        this.stage = stage;
        this.drafter = drafter;
        this.drafterName = drafterName;
        this.type = type;
        this.level = level;
        this.title = title;
        this.url = url;
        this.sender = sender;
        this.senderName = senderName;
        this.receiver = receiver;
        this.receiverName = receiverName;
        this.actionTime = actionTime;
        this.additionalData = additionalData;
        this.syncStatus = syncStatus;
    }

    /**
     *
     */
    public void read() {
        if (this.actionTime == null) {
            this.actionTime = new Date();
        }
        this.type = TodoType.READ;
        this.syncStatus = 0;
    }

    /**
     *
     */
    public void action() {
        if (this.actionTime == null) {
            this.actionTime = new Date();
        }
        this.type = TodoType.DONE;
        this.syncStatus = 0;
    }

    // region 事件

    /**
     * 通用校验
     */
    public void verify() {
        if (StringUtils.isBlank(this.documentType))
            throw new ValidationException("待办文档类型不可为空");
//        if (StringUtils.isBlank(this.domainId))
//            throw new ValidationException("领域对象ID不可为空");
        if (StringUtils.isBlank(this.receiver))
            throw new ValidationException("接收人不可为空");
        if (this.type == null)
            this.type = TodoType.TODO;
        if (this.level == null)
            this.level = TodoLevel.NORMAL;
    }

    // region 构造方法


    public Todo() {
    }

    /**
     * 新增
     */
    public Todo(String documentType, String domainId, String drafter, String drafterName, TodoType type, TodoLevel level, String title, String url,
                String sender, String senderName, String receiver, String receiverName, String additionalData) {
        this.id = String.valueOf(SnowFlake.instant().nextId());
        this.documentType = documentType;
        this.domainId = domainId;
        this.drafter = drafter;
        this.drafterName = drafterName;
        this.type = type;
        this.level = level;
        this.title = title;
        this.url = url;
        this.sendTime = new Date();
        this.sender = sender;
        this.senderName = senderName;
        this.receiver = receiver;
        this.receiverName = receiverName;
        this.additionalData = additionalData;
        this.syncStatus = 0;
    }

    /**
     * 新增
     */
    public Todo(String id, String documentType, String domainId, String stage, String drafter, String drafterName, TodoType type,
                TodoLevel level, String title, String url, String sender, String senderName, String receiver, String receiverName,
                String additionalData) {
        this.id = id;
        this.documentType = documentType;
        this.stage = stage;
        this.domainId = domainId;
        this.drafter = drafter;
        this.drafterName = drafterName;
        this.type = type;
        this.level = level;
        this.title = title;
        this.url = url;
        this.sendTime = new Date();
        this.sender = sender;
        this.senderName = senderName;
        this.receiver = receiver;
        this.receiverName = receiverName;
        this.additionalData = additionalData;
        this.syncStatus = 0;
    }

    /**
     * 构造函数，新建
     */
    public Todo(String documentType, String domainId, String processId, String activityId
            , String stage, String drafter, String drafterName, TodoType type, TodoLevel level, String title, String url
            , Date sendTime, String sender, String senderName, String receiver, String receiverName, Date actionTime
            , String additionalData, String urlMoa) {
        this.id = String.valueOf(SnowFlake.instant().nextId());
        this.documentType = documentType;
        this.domainId = domainId;
        this.processId = processId;
        this.activityId = activityId;
        if (StringUtils.isBlank(stage)) {
            this.stage = this.documentType;
        } else {
            this.stage = stage;
        }
        this.drafter = drafter;
        this.drafterName = drafterName;
        this.type = type;
        this.level = level;
        this.title = title;
        this.url = url;
        this.sendTime = sendTime;
        this.sender = sender;
        this.senderName = senderName;
        this.receiver = receiver;
        this.receiverName = receiverName;
        this.actionTime = actionTime;
        this.additionalData = additionalData;
        this.syncStatus = 0;
        this.urlMoa = urlMoa;
    }

    /**
     * 构造函数，还原
     */
    public Todo(String id, String documentType, String domainId, String processId, String activityId
            , String stage, String drafter, String drafterName, TodoType type, TodoLevel level, String title, String url
            , Date sendTime, String sender, String senderName, String receiver, String receiverName, Date actionTime
            , String additionalData, Integer syncStatus, String urlMoa) {
        this.id = id;
        this.documentType = documentType;
        this.domainId = domainId;
        this.processId = processId;
        this.activityId = activityId;
        this.stage = stage;
        this.drafter = drafter;
        this.drafterName = drafterName;
        this.type = type;
        this.level = level;
        this.title = title;
        this.url = url;
        this.sendTime = sendTime;
        this.sender = sender;
        this.senderName = senderName;
        this.receiver = receiver;
        this.receiverName = receiverName;
        this.actionTime = actionTime;
        this.additionalData = additionalData;
        this.syncStatus = syncStatus;
        this.urlMoa = urlMoa;
    }

    // endregion 构造方法

    // region 额外属性

    /**
     * 是否已处理
     */
    public boolean isAction() {
        return actionTime != null;
    }

    // endregion 额外属性

    // region 基础属性

    /**
     * id，唯一标识
     */
    private String id;
    /**
     * 单据类型
     */
    private String documentType;
    /**
     * 领域对象Id
     */
    private String domainId;
    /**
     * 运行时流程Id
     */
    private String processId;
    /**
     * 运行时流程活动Id
     */
    private String activityId;
    /**
     * 当前阶段
     */
    private String stage;
    /**
     * 起草人
     */
    private String drafter;
    /**
     * 起草人名称
     */
    private String drafterName;
    /**
     * 待办类型
     */
    private TodoType type;
    /**
     * 紧急程度
     */
    private TodoLevel level;
    /**
     * 标题
     */
    private String title;
    /**
     * 处理地址
     */
    private String url;
    /**
     * 发送时间
     */
    private Date sendTime;
    /**
     * 发起人Id
     */
    private String sender;
    /**
     * 发送人名称
     */
    private String senderName;
    /**
     * 接收人Id
     */
    private String receiver;
    /**
     * 接收人名称
     */
    private String receiverName;
    /**
     * 处理时间
     */
    private Date actionTime;
    /**
     * 附加数据
     */
    private String additionalData;
    /**
     * 同步状态
     */
    private Integer syncStatus;
    /**
     * MOA跳转地址
     */
    private String urlMoa;

    public String getId() {
        return id;
    }

    public String getDocumentType() {
        return documentType == null ? "" : documentType;
    }

    public String getDomainId() {
        return domainId == null ? "" : domainId;
    }

    public String getProcessId() {
        return processId == null ? "" : processId;
    }

    public String getActivityId() {
        return activityId == null ? "" : activityId;
    }

    public String getStage() {
        return stage == null ? "" : stage;
    }

    public String getDrafter() {
        return drafter == null ? "" : drafter;
    }

    public String getDrafterName() {
        return drafterName == null ? "" : drafterName;
    }

    public TodoType getType() {
        return type;
    }

    public TodoLevel getLevel() {
        return level;
    }

    public String getTitle() {
        return title == null ? "" : title;
    }

    public String getUrl() {
        return url == null ? "" : url;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public String getSender() {
        return sender == null ? "" : sender;
    }

    public String getSenderName() {
        return senderName == null ? "" : senderName;
    }

    public String getReceiver() {
        return receiver == null ? "" : receiver;
    }

    public String getReceiverName() {
        return receiverName == null ? "" : receiverName;
    }

    public Date getActionTime() {
        return actionTime;
    }

    public String getAdditionalData() {
        return additionalData == null ? "" : additionalData;
    }

    public Integer getSyncStatus() {
        return syncStatus;
    }

    public String getUrlMoa() {
        return urlMoa;
    }

    // endregion 基础属性

}
