package com.infoepoch.pms.dispatchassistant.domain.basic.store;

import com.infoepoch.pms.dispatchassistant.common.exception.ValidationException;
import com.infoepoch.pms.dispatchassistant.common.utils.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 键值对仓库实体
 */
public class KeyValueStore {

    public void fileIdListToValue() {
        if(CollectionUtils.isEmpty(this.fileIdList)) {
            this.value = JsonUtils.objectToJson(new ArrayList<>());
        } else {
            this.value = JsonUtils.objectToJson(this.fileIdList);
        }
    }

    public void check() {
        if (StringUtils.isEmpty(this.key))
            throw new ValidationException("键不可为空");
        if (StringUtils.isEmpty(this.value))
            throw new ValidationException("值不可为空");
    }

    public KeyValueStore() {
    }

    public KeyValueStore(String key, String value) {
        this.key = key;
        this.value = value;
        if (StringUtils.isNotBlank(this.value) && this.value.startsWith("[")) {
            try {
                this.fileIdList = JsonUtils.jsonToList(this.value, String.class);
            } catch (Exception e) {
                this.fileIdList = Collections.EMPTY_LIST;
            }
        }
    }

    private String key;
    private String value;

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    // region 额外属性

    private List<String> fileIdList;

    public List<String> getFileIdList() {
        return fileIdList;
    }
    // endregion 额外属性
}
